#include <xc.h>
#include <pic16f886.h>
#include "port_init.h"
#include "user_define.h"
#include "si47xx_fm.h"
#include "hitec_c_i2c.h"
#include "ad.h"

#pragma config BOREN = OFF
#pragma config CPD = OFF 
#pragma config FOSC =INTRC_NOCLKOUT  
#pragma config MCLRE = ON 
#pragma config WDTE = OFF 
#pragma config CP = OFF 
#pragma config LVP = OFF 
#pragma config PWRTE = ON
#pragma config IESO =OFF
#pragma config FCMEN = OFF

#pragma config BOR4V = BOR21V
#pragma config WRT = OFF

u8  			cmd[8];
u8  			rsp[15];
u8  			RSSI;
u8  			STC;
u8  			BLTF;
u8  			AFCRL;
u8  			Valid;
u16 			Freq;
u8  			ASNR;
u16 			AntCap;

u8				partNumber;
char 			fwMajor;
char 			fwMinor;
u16 			patchID;
char			cmpMajor;
char			cmpMinor;
char			chipRev;

unsigned int	mhz_no;
unsigned int	mhz_no_m;
unsigned char	mode;

unsigned int	preset[12]={7790,8020,8490,8640,8720,9360,7790,8020,8490,8640,8720,9360};
unsigned int    stereo_mono[12]={0,0,0,0,0,0,1,1,1,1,1,1};
unsigned int    stm;
unsigned int	cnt_no;
unsigned int	cnt_mhz;

unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;

unsigned char	sw1p;

unsigned char	tun_flg;

unsigned int	vol_count;
unsigned char	font[10]={0x3f,0x06,0x5b,0x4f,0x66,0x6d,0x7d,0x27,0x7f,0x6f};

#define			LED_WAIT	5

/*---------------------7SEG LED-------------------*/
void	led_mhz(unsigned int hz)
{
unsigned char n0,n1,n2,n3;
unsigned int count;

    count=hz;
	n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);count=(count-n1)/10;
	n2=(unsigned char)(count%10);count=(count-n2)/10;
	n3=(unsigned char)(count%10);
	
	LED_COM0=1;NOP();
	LED_COM1=1;NOP();
	LED_COM2=1;NOP();

	PORTA=~(font[n3]);NOP();
	LED_COM2=0;NOP();
	__delay_ms(LED_WAIT);
	LED_COM2=1;NOP();

	PORTA=~(font[n2]| 0x80);NOP();
	LED_COM1=0;NOP();
	__delay_ms(LED_WAIT);
	LED_COM1=1;NOP();

	PORTA=~(font[n1]| (0x80*stm));NOP();
	LED_COM0=0;NOP();
	__delay_ms(LED_WAIT);
	LED_COM0=1;NOP();

	LED_COM0=1;NOP();
	LED_COM1=1;NOP();
	LED_COM2=1;NOP();
}

/*---------------------MAIN-----------------------*/
void	main(void)
{

	port_init();

	__delay_ms(2000);

	sw1_key=0;sw1_rep=0;sw1_cnt=0;
	mode=1;
	mhz_no=FREQ_MIN;
	cnt_mhz=FREQ_MIN;
	vol_count=0;
	cnt_no=0;
	mhz_no_m=FREQ_MAX;

	I2CInit();	

	while(1){
	//****************************

	sw1p=RB1;NOP();

	si47xxFMRX_initialize();
    si47xx_getPartInformation();

    si47xx_set_property(RX_HARD_MUTE, 0);
  	si47xx_set_property(RX_VOLUME, (u16)63 & RX_VOLUME_MASK);

	__delay_ms(1000);

	mhz_no=vol_yomi();
	if(mhz_no>FREQ_MAX){mhz_no=FREQ_MAX;}
	
    stm=0;
    
	while(1){

		sw1p=RB1;NOP();

	/* key scan 1 */
		if (sw1p==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/

		led_mhz(mhz_no);

		/*wait_time(1000);*/

		sw1p=RB1;NOP();

	/* key scan 2 */
		if ((sw1p==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/

	/* key action */
	
		if((sw1_key==0)&&(sw1_rep==0)){
			mode=1;
		}
		else{
			mode=0;
		}

		/*------------------ */
		//**************************
		if(mode==1){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				mhz_no=vol_yomi();
				if(mhz_no>FREQ_MAX){mhz_no=FREQ_MAX;}				

				if(mhz_no_m!=mhz_no){
                    stm=0;
                    st_mono_sub(stm);
					led_mhz(mhz_no);
					tune_sub(mhz_no);
					mhz_no_m=mhz_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}
		/*------------------ */
		if(mode==0){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				cnt_no=vol_yomi_cnt();
				if(cnt_no>11){cnt_no=11;}
				cnt_mhz=preset[cnt_no];
				if(cnt_mhz!=0){mhz_no=cnt_mhz;}
				if(mhz_no>FREQ_MAX){mhz_no=FREQ_MAX;}				
				if(mhz_no_m!=mhz_no){
                    stm=stereo_mono[cnt_no];
                    //stm=1;
					led_mhz(mhz_no);
                    st_mono_sub(stm);                    
					tune_sub(mhz_no);
					mhz_no_m=mhz_no;
				}
				vol_count=VOL_COUNT_SET;
			}
		}
		/**********************/

	}
	//*************************************************

	}

}