/**
  Generated Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This is the main file generated using PIC10 / PIC12 / PIC16 / PIC18 MCUs

  Description:
    This header file provides implementations for driver APIs for all modules selected in the GUI.
    Generation Information :
        Product Revision  :  PIC10 / PIC12 / PIC16 / PIC18 MCUs - 1.81.7
        Device            :  PIC16F18326
        Driver Version    :  2.00
*/

/*
    (c) 2018 Microchip Technology Inc. and its subsidiaries. 
    
    Subject to your compliance with these terms, you may use Microchip software and any 
    derivatives exclusively with Microchip products. It is your responsibility to comply with third party 
    license terms applicable to your use of third party software (including open source software) that 
    may accompany Microchip software.
    
    THIS SOFTWARE IS SUPPLIED BY MICROCHIP "AS IS". NO WARRANTIES, WHETHER 
    EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY 
    IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY, AND FITNESS 
    FOR A PARTICULAR PURPOSE.
    
    IN NO EVENT WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY KIND 
    WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF MICROCHIP 
    HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE FORESEEABLE. TO 
    THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP'S TOTAL LIABILITY ON ALL 
    CLAIMS IN ANY WAY RELATED TO THIS SOFTWARE WILL NOT EXCEED THE AMOUNT 
    OF FEES, IF ANY, THAT YOU HAVE PAID DIRECTLY TO MICROCHIP FOR THIS 
    SOFTWARE.
*/

#include "mcc_generated_files/mcc.h"
#include "mcc_generated_files/examples/i2c1_master_example.h"

#define     I2C_RADIO_ADDR  0x11
#define     FREQ_INIT       8920
#define		MUTE_RSSI				30

#define     OK_LED          RA5
#define     RSTB            RC5

/*
//==================================================================
// General Commands
//==================================================================
*/

/* STATUS bits - Used by all methods */
#define STCINT  0x01
#define ASQINT  0x02
#define RDSINT  0x04
#define RSQINT  0x08
#define ERR     0x40
#define CTS     0x80

/* POWER_UP*/
#define POWER_UP                      0x01
#define POWER_UP_IN_FUNC_FMRX         0x00
/*
#define POWER_UP_IN_FUNC_AMRX         0x01
#define POWER_UP_IN_FUNC_FMTX         0x02
#define POWER_UP_IN_FUNC_WBRX         0x03
#define POWER_UP_IN_FUNC_QUERY        0x0F
#define POWER_UP_IN_PATCH             0x20
#define POWER_UP_IN_GPO2OEN           0x40
#define POWER_UP_IN_CTSIEN            0x80
*/
#define POWER_UP_IN_OPMODE_RX_ANALOG  0x05
/*
#define POWER_UP_IN_OPMODE_TX_ANALOG  0x50
*/
#define POWER_UP_IN_XOSCEN			  0x10

/* GET_REV */
#define GET_REV 0x10

/* POWER_DOWN */
#define POWER_DOWN 0x11

/* SET_PROPERTY */
#define SET_PROPERTY 0x12

/* GET_PROPERTY */
#define GET_PROPERTY 0x13

/* GET_INT_STATUS */
#define GET_INT_STATUS 0x14

/*
//==================================================================
// FM Receive Commands
//==================================================================
*/
/*// FM_TUNE_FREQ*/
#define FM_TUNE_FREQ 0x20

/*// FM_TUNE_STATUS*/
#define FM_TUNE_STATUS           0x22
#define FM_TUNE_STATUS_IN_INTACK 0x01
#define FM_TUNE_STATUS_IN_CANCEL 0x02
#define FM_TUNE_STATUS_OUT_VALID 0x01
#define FM_TUNE_STATUS_OUT_AFCRL 0x02
#define FM_TUNE_STATUS_OUT_BTLF  0x80

/*// FM_RSQ_STATUS*/
#define FM_RSQ_STATUS              0x23
#define FM_RSQ_STATUS_IN_INTACK    0x01
#define FM_RSQ_STATUS_OUT_RSSILINT 0x01
#define FM_RSQ_STATUS_OUT_RSSIHINT 0x02
#define FM_RSQ_STATUS_OUT_ASNRLINT 0x04
#define FM_RSQ_STATUS_OUT_ASNRHINT 0x08
#define FM_RSQ_STATUS_OUT_BLENDINT 0x80
#define FM_RSQ_STATUS_OUT_VALID    0x01
#define FM_RSQ_STATUS_OUT_AFCRL    0x02
#define FM_RSQ_STATUS_OUT_SMUTE    0x08
#define FM_RSQ_STATUS_OUT_PILOT    0x80
#define FM_RSQ_STATUS_OUT_STBLEND  0x7F

/*
//==================================================================
// FM Receive Properties
//==================================================================
*/
/*// FM_DEEMPHASIS*/
#define FM_DEEMPHASIS      0x1100
#define FM_DEEMPHASIS_MASK 0x0003
#define FM_DEEMPHASIS_SHFT 0

/*// FM_CHANNEL_FILTER*/
#define FM_CHANNEL_FILTER				0x1102
#define FM_CHANNEL_FILTER_WIDE			0x0001
#define FM_CHANNEL_FILTER_NARROW		0x0002
#define FM_CHANNEL_FILTER_NARROWER		0x0003
#define FM_CHANNEL_FILTER_NARROWEST		0x0004

/*// FM_BLEND_STEREO_THRESHOLD*/
//#define FM_BLEND_STEREO_THRESHOLD      0x1105
#define FM_BLEND_STEREO_THRESHOLD      0x1800   //20220418
#define FM_BLEND_STEREO_THRESHOLD_MASK 0x007F
#define FM_BLEND_STEREO_THRESHOLD_SHFT 0

/*// FM_BLEND_MONO_THRESHOLD*/
//#define FM_BLEND_MONO_THRESHOLD      0x1106
#define FM_BLEND_MONO_THRESHOLD      0x1801 //20220418
#define FM_BLEND_MONO_THRESHOLD_MASK 0x007F
#define FM_BLEND_MONO_THRESHOLD_SHFT 0


/*// FM_MAX_TUNE_ERROR*/
#define FM_MAX_TUNE_ERROR      0x1108
#define FM_MAX_TUNE_ERROR_MASK 0x007F
#define FM_MAX_TUNE_ERROR_SHFT 0

/*// FM_RSQ_INT_SOURCE*/
#define FM_RSQ_INT_SOURCE               0x1200
#define FM_RSQ_INT_SOURCE_RSSILIEN_MASK 0x0001
#define FM_RSQ_INT_SOURCE_RSSIHIEN_MASK 0x0002
#define FM_RSQ_INT_SOURCE_ASNRLIEN_MASK 0x0004
#define FM_RSQ_INT_SOURCE_ASNRHIEN_MASK 0x0008
#define FM_RSQ_INT_SOURCE_BLENDIEN_MASK 0x0080
#define FM_RSQ_INT_SOURCE_RSSILIEN_SHFT 0
#define FM_RSQ_INT_SOURCE_RSSIHIEN_SHFT 1
#define FM_RSQ_INT_SOURCE_ASNRLIEN_SHFT 2
#define FM_RSQ_INT_SOURCE_ASNRHIEN_SHFT 3
#define FM_RSQ_INT_SOURCE_BLENDIEN_SHFT 7

/*// FM_RSQ_SNR_HI_THRESHOLD*/
#define FM_RSQ_SNR_HI_THRESHOLD      0x1201
#define FM_RSQ_SNR_HI_THRESHOLD_MASK 0x007F
#define FM_RSQ_SNR_HI_THRESHOLD_SHFT 0

/*// FM_RSQ_SNR_LO_THRESHOLD*/
#define FM_RSQ_SNR_LO_THRESHOLD      0x1202
#define FM_RSQ_SNR_LO_THRESHOLD_MASK 0x007F
#define FM_RSQ_SNR_LO_THRESHOLD_SHFT 0

/*// FM_RSQ_RSSI_HI_THRESHOLD*/
#define FM_RSQ_RSSI_HI_THRESHOLD      0x1203
#define FM_RSQ_RSSI_HI_THRESHOLD_MASK 0x007F
#define FM_RSQ_RSSI_HI_THRESHOLD_SHFT 0

/*// FM_RSQ_RSSI_LO_THRESHOLD*/
#define FM_RSQ_RSSI_LO_THRESHOLD      0x1204
#define FM_RSQ_RSSI_LO_THRESHOLD_MASK 0x007F
#define FM_RSQ_RSSI_LO_THRESHOLD_SHFT 0

/*// FM_RSQ_BLEND_THRESHOLD*/
#define FM_RSQ_BLEND_THRESHOLD            0x1207
#define FM_RSQ_BLEND_THRESHOLD_BLEND_MASK 0x007F
#define FM_RSQ_BLEND_THRESHOLD_PILOT_MASK 0x0080
#define FM_RSQ_BLEND_THRESHOLD_BLEND_SHFT 0
#define FM_RSQ_BLEND_THRESHOLD_PILOT_SHFT 7

/*// FM_SOFT_MUTE_RATE*/
#define FM_SOFT_MUTE_RATE      0x1300
#define FM_SOFT_MUTE_RATE_MASK 0x00FF
#define FM_SOFT_MUTE_RATE_SHFT 0

/*// FM_SOFT_MUTE_MAX_ATTENUATION*/
#define FM_SOFT_MUTE_MAX_ATTENUATION      0x1302
#define FM_SOFT_MUTE_MAX_ATTENUATION_MASK 0x001F
#define FM_SOFT_MUTE_MAX_ATTENUATION_SHFT 0

/*// FM_SOFT_MUTE_SNR_THRESHOLD*/
#define FM_SOFT_MUTE_SNR_THRESHOLD      0x1303
#define FM_SOFT_MUTE_SNR_THRESHOLD_MASK 0x000F
#define FM_SOFT_MUTE_SNR_THRESHOLD_SHFT 0

/*// FM_SEEK_BAND_BOTTOM*/
#define FM_SEEK_BAND_BOTTOM 0x1400

/*// FM_SEEK_BAND_TOP*/
#define FM_SEEK_BAND_TOP 0x1401

/*// FM_SEEK_FREQ_SPACING*/
#define FM_SEEK_FREQ_SPACING      0x1402
#define FM_SEEK_FREQ_SPACING_MASK 0x001F
#define FM_SEEK_FREQ_SPACING_SHFT 0

/*// FM_SEEK_TUNE_SNR_THRESHOLD*/
#define FM_SEEK_TUNE_SNR_THRESHOLD      0x1403
#define FM_SEEK_TUNE_SNR_THRESHOLD_MASK 0x007F
#define FM_SEEK_TUNE_SNR_THRESHOLD_SHFT 0

/*// FM_SEEK_TUNE_RSSI_THRESHOLD*/
#define FM_SEEK_TUNE_RSSI_THRESHOLD      0x1404
#define FM_SEEK_TUNE_RSSI_THRESHOLD_MASK 0x007F
#define FM_SEEK_TUNE_RSSI_THRESHOLD_SHFT 0

/*// FM_RDS_CONFIG*/
#define FM_RDS_CONFIG             0x1502
#define FM_RDS_CONFIG_RDSEN_MASK  0x0001
#define FM_RDS_CONFIG_BLETHD_MASK 0x0300
#define FM_RDS_CONFIG_BLETHC_MASK 0x0C00
#define FM_RDS_CONFIG_BLETHB_MASK 0x3000
#define FM_RDS_CONFIG_BLETHA_MASK 0xC000
#define FM_RDS_CONFIG_RDSEN_SHFT  0
#define FM_RDS_CONFIG_BLETHD_SHFT 8
#define FM_RDS_CONFIG_BLETHC_SHFT 10
#define FM_RDS_CONFIG_BLETHB_SHFT 12
#define FM_RDS_CONFIG_BLETHA_SHFT 14

/*
//==================================================================
// General Receive Properties
//==================================================================
*/
/* RX_VOLUME */
#define RX_VOLUME      0x4000
#define RX_VOLUME_MASK 0x003F
#define RX_VOLUME_SHFT 0

/* RX_HARD_MUTE */
#define RX_HARD_MUTE 0x4001
#define RX_HARD_MUTE_RMUTE_MASK 0x0001
#define RX_HARD_MUTE_LMUTE_MASK 0x0002
#define RX_HARD_MUTE_RMUTE_SHFT 0
#define RX_HARD_MUTE_LMUTE_SHFT 1
/*
//==================================================================
// Bit Definitions for Properties
//==================================================================
*/
/*// FM_DEEMPH*/
#define FM_DEEMPH_75US 0x2
#define FM_DEEMPH_50US 0x1

/*
//-----------------------------------------------------------------------------
// Defines
//-----------------------------------------------------------------------------
*/
#define READ    1
#define WRITE   0

#define POWERUP_TIME 110    /* Powerup delay in milliseconds*/
#define GPO_IEN				 0x0001
#define GPO_IEN_STCIEN_MASK  0x0001

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************
struct {
	unsigned int PoweredUp : 1;
}Bit;

unsigned char  			cmd[8];
unsigned char  			rsp[15];
unsigned char  			RSSI;
unsigned char  			STC;
unsigned char  			BLTF;
unsigned char  			AFCRL;
unsigned char  			Valid;
unsigned int 			Freq;
unsigned char  			ASNR;
unsigned int 			AntCap;

unsigned char			partNumber;
char                    fwMajor;
char                    fwMinor;
unsigned int 			patchID;
char                    cmpMajor;
char                    cmpMinor;
char                    chipRev;

unsigned int            mhz_no;

/*
                         Main application
 */
//***************************************************************
//Si47xx
//***************************************************************
unsigned char si47xx_readStatus()
{
    unsigned char status;
   
    I2C1_ReadNBytes(I2C_RADIO_ADDR,&status,1);
	__delay_us(500);
    return status;
}

void si47xx_waitForCTS()
{
    unsigned int i=1000;

    while (--i && !(si47xx_readStatus() & CTS))
    {
		__delay_us(500);
    }
}

void si47xx_command(unsigned char cmd_size, unsigned char *cmd, unsigned char reply_size, unsigned char *reply)
{
    si47xx_waitForCTS();
    I2C1_WriteNBytes(I2C_RADIO_ADDR,cmd,cmd_size);
	__delay_us(500);
    si47xx_waitForCTS();
    if(reply_size)
    {
        I2C1_ReadNBytes(I2C_RADIO_ADDR,reply,reply_size);
		__delay_us(500);
    }
}

unsigned char getIntStatus(void)
{
    unsigned char  cmd[1] = {0};
    unsigned char  rsp[1] = {0};

    cmd[0] = GET_INT_STATUS;
	si47xx_command(1, cmd, 1, rsp);
	return rsp[0];
}

void si47xx_set_property(unsigned int propNumber, unsigned int propValue)
{
    cmd[0] = SET_PROPERTY;
    cmd[1] = 0;
    cmd[2] = (unsigned char)(propNumber >> 8);
	cmd[3] = (unsigned char)(propNumber & 0x00FF);
    cmd[4] = (unsigned char)(propValue >> 8);
    cmd[5] = (unsigned char)(propValue & 0x00FF);
	si47xx_command(6, cmd, 0,  0);
}

void si47xx_getPartInformation(void)
{
	cmd[0] = GET_REV;

	si47xx_command(1, cmd, 9, rsp);

	partNumber = rsp[1];
	fwMajor  = (char)rsp[2];
	fwMinor  = (char)rsp[3];
	patchID  = (unsigned int)(rsp[4] << 8) | (unsigned int)rsp[5];
	cmpMajor = (char)rsp[6];
	cmpMinor = (char)rsp[7];
	chipRev  = (char)rsp[8]; 
}

void si47xxFMRX_initialize(void)
{
	Bit.PoweredUp = 0;
    RSTB = 0;
	__delay_us(100);
    RSTB = 1;
    __delay_us(30);
    if (Bit.PoweredUp) {
    } else {
		cmd[0] = POWER_UP;
        cmd[1] = (POWER_UP_IN_FUNC_FMRX | 0x10) ;
        cmd[2] = POWER_UP_IN_OPMODE_RX_ANALOG;
		si47xx_command(3, cmd, 8, rsp);
		__delay_ms(POWERUP_TIME);
		Bit.PoweredUp = 1;
    }
   	si47xx_set_property(GPO_IEN, GPO_IEN_STCIEN_MASK);
	si47xx_set_property(FM_RDS_CONFIG, 0);              
	si47xx_set_property(FM_DEEMPHASIS, FM_DEEMPH_50US);
}

static void fmTuneFreq(unsigned int frequency)
{
    cmd[0] = FM_TUNE_FREQ;
    cmd[1] = 0;
    cmd[2] = (unsigned char)(frequency >> 8);
	cmd[3] = (unsigned char)(frequency & 0x00FF);
    cmd[4] = (unsigned char)0;
	si47xx_command(5, cmd, 1, rsp);
}

static void fmTuneStatus(unsigned char cancel, unsigned char intack)
{
    cmd[0] = FM_TUNE_STATUS;

	cmd[1] = 0;
    if(cancel) cmd[1] |= FM_TUNE_STATUS_IN_CANCEL;
	if(intack) cmd[1] |= FM_TUNE_STATUS_IN_INTACK;

	si47xx_command(2, cmd, 8, rsp);

    STC    = !!(rsp[0] & STCINT);
    BLTF   = !!(rsp[1] & FM_TUNE_STATUS_OUT_BTLF);
    AFCRL  = !!(rsp[1] & FM_TUNE_STATUS_OUT_AFCRL);
    Valid  = !!(rsp[1] & FM_TUNE_STATUS_OUT_VALID);
    Freq   = ((unsigned int)rsp[2] << 8) | (unsigned int)rsp[3];
    RSSI   = rsp[4];
    ASNR   = rsp[5];
    AntCap = rsp[7];   
}

static void fmRsqStatus(void)
{
    cmd[0] = FM_RSQ_STATUS;

	cmd[1] = 0;

	si47xx_command(2, cmd, 8, rsp);

    RSSI   = rsp[4];
    ASNR   = rsp[5];
}

void	tune_sub(unsigned int fm_mhz)
{
    fmTuneFreq(fm_mhz);
    while (!(getIntStatus() & STCINT));
    fmTuneStatus(0, 1);
    if(RSSI>99){RSSI=99;}
    if(ASNR>99){ASNR=99;}
	if(RSSI>=MUTE_RSSI){
    	si47xx_set_property(RX_VOLUME, (unsigned int)63 & RX_VOLUME_MASK);
	}
}

void    tune_status(void)
{
    fmRsqStatus();
    if(RSSI>99){RSSI=99;}
    if(ASNR>99){ASNR=99;}
	if(RSSI>=MUTE_RSSI){
    	si47xx_set_property(RX_VOLUME, (unsigned int)63 & RX_VOLUME_MASK);
	}    
}

//-------------------------------------

void main(void)
{
    // initialize the device
    SYSTEM_Initialize();

    // When using interrupts, you need to set the Global and Peripheral Interrupt Enable bits
    // Use the following macros to:

    // Enable the Global Interrupts
    INTERRUPT_GlobalInterruptEnable();

    // Enable the Peripheral Interrupts
    INTERRUPT_PeripheralInterruptEnable();

    // Disable the Global Interrupts
    //INTERRUPT_GlobalInterruptDisable();

    // Disable the Peripheral Interrupts
    //INTERRUPT_PeripheralInterruptDisable();
    
    __delay_ms(150);

	mhz_no=FREQ_INIT;

	__delay_ms(1000);
    
	si47xxFMRX_initialize();
    si47xx_getPartInformation();

    si47xx_set_property(RX_HARD_MUTE, 0);
  	si47xx_set_property(RX_VOLUME, (unsigned int)63 & RX_VOLUME_MASK);
  
	__delay_ms(1000);
   
 	tune_sub(mhz_no);
	
	__delay_ms(1000);

    OK_LED=1;
    SLEEP();

    while (1)
    {
        // Add your application code
        NOP();
    }
}
/**
 End of File
*/