/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include <cp0defs.h>

#define u32 unsigned long
#define u16 unsigned int
#define u8  unsigned char
#define i8  char

#define     LCD_RST     GPIO_PIN_RB7      //RB7 //7
#define     LCD_CS      GPIO_PIN_RB5      //RB5 //5
#define     LCD_WR      GPIO_PIN_RB3      //RB3 //3
#define     LCD_DC      GPIO_PIN_RB6      //RB6 //6
#define     LCD_RD      GPIO_PIN_RB2      //RB2 //2

//#define     SW1         GPIO_PIN_RB15
//#define     SW2         GPIO_PIN_RB14
//#define     SW3         GPIO_PIN_RE4
#define     MUTE        GPIO_PIN_RB12
//#define     SP_CONT     GPIO_PIN_RB9

#define     I2C_VOL_ADDR    0x44

#define		VOLUME_MIN				24
#define		VOLUME_MAX				119

#define		VOL_COUNT_SET			100
#define 	FREQ_MANUAL_DIV			10  //8
#define		FREQ_MANUAL_DIV_CNT		100 //80

/*
//==================================================================
// General Commands
//==================================================================
*/


// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************
struct {
	unsigned int PoweredUp : 1;
}Bit;

//unsigned char	sw1_key;
//unsigned char	sw1_rep;
//unsigned char	sw1_cnt;
//unsigned char	sw2_key;
//unsigned char	sw2_rep;
//unsigned char	sw2_cnt;
//unsigned char	sw3_key;
//unsigned char	sw3_rep;
//unsigned char	sw3_cnt;

unsigned char   pal_no;

unsigned int	volume_no;
unsigned int	volume_no_m;
unsigned char	mode;
//unsigned char	width;

//unsigned int	preset[13]={864,954,1008,1026,1053,1134,1143,1179,1242,1314,1332,1512,1557};
//unsigned int    stereo_mono[12]={0,0,0,0,0,0,1,1,1,1,1,1};
//unsigned int    stm;

//unsigned int	cnt_no;
//unsigned int	cnt_khz;

//unsigned char	tun_flg;

unsigned int	vol_count;

uint32_t        adc_data;
unsigned short	vol_level;
unsigned short	vol_level_m;

//unsigned short  dc12v_level;

unsigned char   vram[6400];

unsigned char color_data1_init[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2_init[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char color_data1[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char   pal_color[8][16]={
{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15},
{7,15,9,14,4,3,6,0,5,9,10,12,1,13,14,15},
{0,2,1,9,4,11,6,4,13,9,10,3,12,13,14,15},
{7,13,2,14,4,9,6,12,8,9,10,15,1,13,14,15},
{0,9,2,14,4,3,6,8,11,9,10,1,12,13,14,15},
{0,12,2,9,4,1,6,6,8,9,10,3,11,13,14,15},
{0,7,7,7,4,7,6,0,7,9,10,7,7,13,14,15},
{0,0,0,0,4,0,6,7,0,9,10,0,0,13,14,15},
};

const   unsigned char   font_moji_h1[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,51,119,119,7,51,119,119,7,51,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,119,7,51,51,119,0,51,51,119,48,51,51,119,48,51,51,119,48,51,51,7,48,51,3,7,51,51,3,7,51,51,3,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,119,119,51,3,119,119,51,3,119,119,51,0,119,7,51,112,119,7,51,112,119,7,51,112,119,0,51,112,119,48,51,0,0,48,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,51,112,119,7,51,112,119,7,51,112,119,7,51,112,119,0,51,119,119,48,51,119,119,48,51,119,119,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,48,51,51,112,48,51,51,112,48,51,3,112,51,51,3,119,51,51,3,119,51,51,3,119,51,51,0,119,51,51,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,3,112,119,51,3,119,119,51,3,119,119,51,3,119,119,51,3,119,119,51,0,119,119,51,112,119,119,51,112,119,119,0,112,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_p1[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,51,119,119,7,51,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,0,51,51,119,48,51,51,119,48,51,51,119,48,51,51,7,48,51,51,7,51,51,51,7,51,51,51,7,51,51,51,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,0,0,51,3,119,7,51,0,119,0,51,112,7,48,51,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,51,112,119,119,51,112,119,119,3,112,119,119,3,119,119,119,0,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,119,51,51,3,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,51,112,51,51,3,112,51,51,3,119,51,51,3,119,51,51,0,119,51,3,112,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_a2[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,192,119,119,7,192,119,119,7,204,119,119,7,204,119,119,0,204,119,119,192,204,119,7,192,204,119,7,204,204,119,0,204,204,119,192,204,204,7,192,204,204,7,204,204,204,7,204,204,204,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,7,0,0,0,7,204,204,204,0,204,204,204,192,204,204,204,192,204,204,204,204,204,204,204,204,204,204,192,204,204,12,192,204,204,12,192,204,204,0,192,204,204,112,192,204,204,0,192,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,0,0,192,204,112,119,192,12,112,119,192,0,119,119,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,0,0,0,119,119,119,119,119,},
};
const   unsigned char   font_moji_m2[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,204,119,119,0,204,119,119,192,204,119,119,192,204,119,119,192,204,119,119,192,204,119,7,192,204,119,7,204,204,119,7,204,204,119,7,204,204,119,0,204,204,119,192,204,204,119,192,204,204,119,192,204,204,119,192,204,204,7,192,204,204,7,204,204,204,7,204,204,12,7,204,204,12,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,112,0,204,204,112,192,204,204,0,192,204,204,0,204,204,204,0,204,204,204,0,204,204,204,192,204,204,204,192,204,204,204,192,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,204,204,12,12,204,204,12,0,204,204,12,0,204,204,192,0,204,204,192,0,204,12,192,7,204,12,192,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,12,112,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,12,119,204,204,0,119,204,204,112,119,204,204,112,119,204,12,112,119,204,12,119,119,204,12,119,119,204,12,119,119,0,0,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_p2[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,204,119,119,7,204,119,119,0,204,119,119,192,204,119,119,192,204,119,119,192,204,119,7,192,204,119,7,204,204,119,7,204,204,119,7,204,204,119,7,204,204,119,0,204,204,119,192,204,204,119,192,204,204,119,192,204,204,7,192,204,204,7,204,204,204,7,204,204,204,7,204,204,204,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12,0,0,204,12,119,7,204,0,119,0,204,112,7,192,204,0,0,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,0,0,0,204,112,119,119,204,112,119,119,12,112,119,119,12,119,119,119,0,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,119,204,204,12,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,204,112,204,204,12,112,204,204,12,119,204,204,12,119,204,204,0,119,204,12,112,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};

const   unsigned char   font_moji_dot[2][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,0,51,119,119,7,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,3,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,3,112,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_sp[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},    
};

const   unsigned char   font_moji_db1[4][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,7,48,119,119,7,51,119,119,7,51,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,51,51,119,7,48,51,119,119,48,51,119,119,0,51,119,119,7,48,119,119,119,0,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,48,51,3,48,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,51,51,3,112,51,51,0,119,51,51,112,119,51,3,112,119,51,3,119,119,51,3,112,7,51,51,0,0,51,51,3,48,51,51,51,51,51,51,51,51,51,51,51,0,51,51,3,0,51,51,0,7,0,0,112,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,112,7,51,51,0,0,51,51,3,48,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,48,51,51,51,0,51,51,51,7,51,51,51,7,51,51,51,0,51,51,51,48,51,51,51,48,51,51,3,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,3,51,51,51,0,51,51,51,112,0,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,51,3,119,119,51,3,119,119,51,3,119,119,51,0,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,3,112,119,119,3,119,119,119,3,119,119,119,3,119,119,119,3,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_db2[4][128]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,48,119,119,119,48,119,119,119,48,119,119,119,48,119,119,7,48,119,119,7,51,119,119,7,51,119,119,7,51,119,119,7,51,119,119,7,51,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,7,48,51,119,7,51,51,119,7,51,51,119,7,0,0,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,48,51,51,51,48,51,51,51,48,51,51,51,48,51,51,51,51,51,51,51,51,51,3,0,51,51,3,119,51,51,3,119,51,51,3,119,51,51,3,119,51,51,3,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,51,51,112,119,51,51,112,119,51,51,112,119,51,51,112,119,51,51,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,0,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,48,51,51,119,0,51,51,119,7,51,51,119,7,51,51,119,0,51,51,0,48,51,51,51,51,51,0,51,51,51,112,51,51,51,0,0,51,51,51,7,48,51,51,119,48,51,51,119,48,51,51,7,48,51,51,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,3,51,51,0,0,0,0,112,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,3,112,119,119,51,0,119,119,51,3,119,119,51,3,119,119,51,3,119,119,51,3,119,119,51,3,119,119,51,3,119,119,51,0,119,119,3,112,119,119,0,119,119,119,112,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,3,119,119,119,3,119,119,119,3,119,119,119,3,119,119,119,3,119,119,119,3,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};

const   unsigned char   font_suji_0[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,85,119,7,80,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,7,80,85,85,119,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,112,119,85,85,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,5,112,85,85,0,119,85,85,112,119,85,5,112,119,5,0,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_1[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,0,0,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,0,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,5,112,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_2[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,7,0,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,0,0,0,112,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,80,119,119,7,80,119,119,0,85,119,7,80,85,119,7,85,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,112,119,85,85,0,119,85,85,5,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,112,85,5,0,119,85,0,119,119,85,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_3[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,85,119,7,80,85,7,0,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,0,0,0,112,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,0,119,119,119,7,119,119,119,119,0,0,0,119,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,0,85,85,119,7,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,5,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,0,112,5,0,112,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_4[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,7,80,85,119,7,85,85,119,0,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,5,80,85,85,5,80,85,85,5,80,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,0,112,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_5[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,0,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,80,119,119,119,0,119,119,119,7,119,119,119,119,0,119,119,119,5,112,119,7,85,112,119,7,85,0,112,0,85,85,0,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,0,0,0,0,119,119,119,112,119,119,119,0,0,0,119,85,85,5,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,0,112,85,0,112,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_6[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,80,119,119,7,80,119,119,0,85,119,7,80,85,119,7,85,85,119,0,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,5,0,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,7,0,85,85,119,7,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,5,112,85,85,5,119,85,85,0,119,85,5,112,119,85,0,119,119,85,112,119,119,5,0,0,112,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,5,112,85,85,5,119,85,85,0,119,5,0,112,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,0,119,119,5,112,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_7[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,7,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,7,80,85,119,7,85,85,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,0,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,0,119,85,85,112,119,85,85,112,119,85,85,112,119,85,5,112,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_8[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,80,119,119,119,0,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,7,80,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,0,80,85,85,119,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,0,80,85,85,119,80,85,85,0,80,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,0,112,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_9[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,0,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,7,80,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,0,0,80,119,119,0,85,119,119,80,85,119,7,80,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,112,85,85,5,119,85,85,0,119,85,5,112,119,85,0,119,119,85,112,119,119,5,112,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_space[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_bar[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};

const   unsigned char   font_suji_0s[2][64]={
{119,119,119,119,119,119,0,0,119,0,176,187,119,176,187,187,119,176,187,187,7,176,187,187,7,187,187,11,7,187,187,0,7,187,187,112,7,187,187,0,7,187,187,0,7,187,187,187,7,187,187,187,7,187,187,187,7,0,187,187,119,7,0,0,},
{119,119,119,119,0,0,112,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,11,119,176,187,11,119,176,187,11,119,176,187,11,119,176,187,11,119,187,187,11,119,187,187,0,119,187,187,112,119,187,11,112,119,11,0,119,119,0,119,119,119,},
};
const   unsigned char   font_suji_1s[2][64]={
{119,119,119,119,119,119,7,0,119,119,0,187,119,119,176,187,119,7,176,187,119,0,187,187,119,176,187,187,119,176,11,187,119,0,0,187,119,119,176,187,119,119,176,187,119,119,176,187,119,7,176,187,119,7,187,187,119,7,187,187,119,7,0,0,},
{119,119,119,119,0,0,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,11,112,119,187,11,119,119,187,11,119,119,187,11,119,119,187,11,119,119,187,0,119,119,187,112,119,119,187,112,119,119,187,112,119,119,0,112,119,119,},
};
const   unsigned char   font_suji_2s[2][64]={
{119,119,119,119,119,119,7,0,119,119,0,187,119,119,176,187,119,7,187,187,119,0,187,187,119,176,187,11,119,176,187,11,119,0,0,0,119,119,0,176,119,0,176,187,7,176,187,187,7,187,187,187,7,187,187,187,7,187,187,187,7,0,0,0,},
{119,119,119,119,0,0,0,119,187,187,11,112,187,187,187,112,187,187,187,112,187,187,187,112,0,187,187,112,176,187,187,112,187,187,11,112,187,187,0,119,187,0,0,119,187,187,11,119,187,187,11,119,187,187,11,119,187,187,0,119,0,0,112,119,},
};
const   unsigned char   font_suji_3s[2][64]={
{119,119,119,119,119,7,0,0,119,7,187,187,119,0,187,187,119,176,187,187,119,0,0,0,119,119,0,176,119,7,176,187,119,7,187,187,119,7,0,0,7,0,112,0,7,187,0,176,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,187,112,187,187,11,112,187,11,0,119,187,0,112,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,11,119,187,187,0,119,187,187,112,119,187,0,112,119,0,112,119,119,},
};
const   unsigned char   font_suji_4s[2][64]={
{119,119,119,119,119,119,119,0,119,119,7,176,119,119,0,187,119,119,176,187,119,7,176,187,119,0,187,187,119,176,187,11,7,176,187,0,7,187,187,0,7,187,187,187,7,187,187,187,7,187,187,187,7,0,0,176,119,119,119,176,119,119,119,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,176,187,11,119,176,187,11,119,187,187,0,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,11,119,187,11,0,119,187,11,119,119,0,0,119,119,},
};
const   unsigned char   font_suji_5s[2][64]={
{119,119,119,119,119,7,0,0,119,7,187,187,119,7,187,187,119,0,187,187,119,176,187,187,119,176,187,11,119,176,187,187,119,176,187,187,119,0,0,176,7,0,112,0,7,187,0,176,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,0,0,0,119,187,11,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,11,112,119,187,0,119,119,0,112,119,119,},
};
const   unsigned char   font_suji_6s[2][64]={
{119,119,119,119,119,119,0,0,119,7,176,187,119,0,187,187,119,176,187,187,119,176,187,187,7,176,187,11,7,187,187,187,7,187,187,187,7,187,187,0,7,187,187,0,7,187,187,0,7,187,187,187,7,176,187,187,119,0,187,187,119,7,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,0,187,11,119,0,0,0,119,187,187,112,119,187,187,0,119,187,187,11,119,187,187,11,119,187,187,0,119,187,187,112,119,187,11,112,119,187,0,119,119,0,112,119,119,},
};
const   unsigned char   font_suji_7s[2][64]={
{119,119,119,119,119,0,0,0,119,176,187,187,7,176,187,187,7,187,187,187,7,187,187,187,7,0,0,176,119,119,7,187,119,119,0,187,119,7,176,187,119,7,187,187,119,0,187,187,7,176,187,187,7,187,187,187,7,187,187,11,7,0,0,0,},
{119,119,119,119,0,0,0,112,187,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,187,187,11,119,187,187,0,119,187,11,112,119,187,11,119,119,187,0,119,119,11,112,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,},
};
const   unsigned char   font_suji_8s[2][64]={
{119,119,119,119,119,119,0,0,119,7,176,187,119,0,187,187,119,176,187,187,119,176,187,187,119,176,187,11,119,0,187,187,119,0,176,187,7,176,187,187,7,187,187,11,7,187,187,0,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,0,119,187,187,11,112,187,187,187,112,187,187,187,112,0,187,187,112,176,187,187,112,187,187,11,112,187,11,0,119,187,187,11,119,176,187,11,119,187,187,11,119,187,187,11,119,187,187,0,119,187,0,112,119,0,0,119,119,},
};
const   unsigned char   font_suji_9s[2][64]={
{119,119,119,119,119,119,0,0,119,0,176,187,119,176,187,187,119,176,187,187,7,176,187,11,7,187,187,11,7,187,187,11,7,187,187,187,7,176,187,187,119,0,187,11,7,0,0,176,7,187,187,187,7,187,187,187,7,176,187,187,119,0,0,0,},
{119,119,119,119,0,0,112,119,187,187,0,119,187,187,11,119,187,187,11,112,176,187,187,112,176,187,187,112,176,187,187,112,187,187,187,112,187,187,11,112,187,187,11,119,187,187,11,119,187,187,0,119,187,11,112,119,187,0,119,119,0,112,119,119,},
};

const unsigned char font_suji_8_dot1[32]={7,0,0,112,0,34,34,0,32,34,34,2,32,34,34,2,32,34,34,2,32,34,34,2,0,34,34,0,7,0,0,112,};
const unsigned char font_suji_8_dot2[32]={7,0,0,112,0,17,17,0,16,17,17,1,16,17,17,1,16,17,17,1,16,17,17,1,0,17,17,0,7,0,0,112,};
const unsigned char font_suji_8_dot3[32]={7,0,0,112,0,102,102,0,96,102,102,6,96,102,102,6,96,102,102,6,96,102,102,6,0,102,102,0,7,0,0,112,};
const unsigned char font_suji_8_dot4[32]={7,0,0,112,0,51,51,0,48,51,51,3,48,51,51,3,48,51,51,3,48,51,51,3,0,51,51,0,7,0,0,112,};
const unsigned char font_suji_8_dot5[32]={7,0,0,112,0,85,85,0,80,85,85,5,80,85,85,5,80,85,85,5,80,85,85,5,0,85,85,0,7,0,0,112,};



//unsigned char test_moji1[20]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
//unsigned char test_moji2[26]={10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35};

// delay
#define CCLK		(800000L)//	(9600000L)
#define PBCLK		(CCLK / 2)
#define SAMPLE_RATE	5000
#define CCLK_US		(PBCLK / 100 / 1000)
#define CCLK_MS		(PBCLK / 100)

void delay_us(unsigned int  d) 
{
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();     
	delayCount = d * CCLK_US; 
	while((_CP0_GET_COUNT() - startTime) < delayCount);  
 }

void delay_ms(unsigned int d)
{   
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();   
	delayCount = d * CCLK_MS;   
	while((_CP0_GET_COUNT() - startTime) < delayCount);   
}

void    send_cmd(unsigned char cmd)
{
    GPIO_PinWrite(LCD_DC,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)cmd);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data(unsigned char data)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_2(unsigned char data1,unsigned char data2)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_4(unsigned char data1,unsigned char data2,unsigned char data3,unsigned char data4)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data3);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data4);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}


void    set_up(void)
{
    GPIO_PinWrite(LCD_RST,1);
    delay_us(10);
    GPIO_PinWrite(LCD_WR,0);
    delay_us(10);
    GPIO_PinWrite(LCD_RD,1);
    delay_us(10);    
    GPIO_PinWrite(LCD_CS,0);
    delay_us(10);
    
    send_cmd(0x3a);
    send_data(0x05);    
    
    send_cmd(0xb1);
    send_data(0x05);
    send_data(0x3c);    
    send_data(0x3c);      

    send_cmd(0xb2);
    send_data(0x05);
    send_data(0x3c);  
    send_data(0x3c);      
    
    send_cmd(0xb3);
    send_data(0x05);
    send_data(0x3c); 
    send_data(0x3c); 

    send_cmd(0xb4);
    send_data(0x03);    
    
    send_cmd(0xc0);
    send_data(0xe0);
    send_data(0x00);
    send_data(0x84);    

    send_cmd(0xc1);
    send_data(0x05);
    
    send_cmd(0xc2);
    send_data(0x0d);
    send_data(0x00);   

    send_cmd(0xc3);
    send_data(0x8d);
    send_data(0xea);   

    send_cmd(0xc4);
    send_data(0x8d);
    send_data(0xee);
    
    send_cmd(0xc5);
    send_data(0x03);    
    
    send_cmd(0xc7);
    send_data(0x0a);  

    send_cmd(0x36);
    send_data(0x68);        //c8

    send_cmd(0xe0);
    send_data(0x1b);
    send_data(0x1a);
    send_data(0x10);
    send_data(0x15);
    send_data(0x34);
    send_data(0x2e);
    send_data(0x2a);
    send_data(0x2a);
    send_data(0x2c);
    send_data(0x27);
    send_data(0x2e);
    send_data(0x39);
    send_data(0x00);
    send_data(0x15);
    send_data(0x02);
    send_data(0x3f);

    send_cmd(0xe1);
    send_data(0x1a);
    send_data(0x1a);
    send_data(0x0f);
    send_data(0x15);
    send_data(0x34);
    send_data(0x2e);
    send_data(0x25);
    send_data(0x2b);
    send_data(0x26);
    send_data(0x26);
    send_data(0x2f);
    send_data(0x3a);
    send_data(0x00);
    send_data(0x15);
    send_data(0x02);
    send_data(0x3f);

    send_cmd(0x11);
    delay_ms(130);    

    send_cmd(0x29);
    delay_ms(100);
    
    send_cmd(0x2a);
    send_data_4(0x00,0x00,0x00,0x9f);       //0x00,0x18,0x00,0x67
    
    send_cmd(0x2b);
    send_data_4(0x00,0x18,0x00,0x68);       //0x00,0x00,0x00,0x9f  
}

void    disp_main2(void)
{
    unsigned int    i;
    unsigned char   data1,data2;

            GPIO_PinWrite(GPIO_PIN_RE5,1);
            send_cmd(0x2a);
            send_data_4(0x00,0x00,0x00,0x9f);       //0x00,0x18,0x00,0x67
            send_cmd(0x2b);
            send_data_4(0x00,0x18,0x00,0x68);       //0x00,0x00,0x00,0xa0 
            send_cmd(0x2c);
    
            GPIO_PinWrite(LCD_DC,1);
            
            for (i=0;i<6400;i++){
                data2=vram[i] >> 4;
                data1=vram[i] & 0x0f;
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
            }
            GPIO_PinWrite(GPIO_PIN_RE5,0);                
}

void    vram_clear(unsigned char color)
{
    unsigned int i;
    unsigned char data;
    
    data=(color << 4) | color;
    
    for(i=0;i<6400;i++){
        vram[i]=data;
    }
}
void    vram_set_8_dot1(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j;
    
    for(j=0;j<8;j++){
        for(i=0;i<4;i++){
            data=font_suji_8_dot1[j*4+i];
            vram[xx+i+(yy*2+j)*80]=data;
        }
    }
}
void    vram_set_8_dot2(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j;
    
    for(j=0;j<8;j++){
        for(i=0;i<4;i++){
            data=font_suji_8_dot2[j*4+i];
            vram[xx+i+(yy*2+j)*80]=data;
        }
    }
}

void    vram_set_hpamp(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;

    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_h1[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_p1[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+18;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_a2[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_m2[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_p2[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
}

void    vram_set_db(unsigned  int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<4;k++){
        for(j=0;j<32;j++){
            for(i=0;i<4;i++){
                data=font_moji_db1[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    
    offset=offset+16;
    for(k=0;k<4;k++){
        for(j=0;j<32;j++){
            for(i=0;i<4;i++){
                data=font_moji_db2[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }    
}
void    vram_set_suji_bar(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    
        for(k=0;k<4;k++){
            for(j=0;j<48;j++){
                for(i=0;i<4;i++){
                    data=font_suji_bar[k][j*4+i];
                    vram[k*4+xx+i+(yy*2+j)*80]=data;
                }
            }
        }    
}
void    vram_set_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned int    i,j,k;
    
    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_0[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_1[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_2[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_3[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_4[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_5[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_6[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 7:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_7[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 8:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_8[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 9:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_9[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 10:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_space[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 11:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_bar[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;            
    }
}
void    vram_set_suji_s(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned int    i,j,k;
    
    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_0s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_1s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_2s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_3s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_4s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_5s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_6s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 7:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_7s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 8:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_8s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 9:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_9s[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
    }
}
void    pal_color_set(void)
{
    unsigned int i;
    
    for (i=0;i<16;i++){
        color_data1[i]=color_data1_init[pal_color[pal_no][i]];
        color_data2[i]=color_data2_init[pal_color[pal_no][i]];
    }
}
void	vram_set_suji_db(unsigned int xx,unsigned int yy,unsigned int db)
{
    unsigned char n0,n1;
    unsigned int count;
    
    if(db>=119){
        db=119;
    }
    count=119-db;
	n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);

    vram_set_suji_bar(xx,yy);
    if(n1==0){
        vram_set_suji(xx+16,yy,10);
    }
    else{
        vram_set_suji(xx+16,yy,n1);
    }
    vram_set_suji(xx+32,yy,n0);
}

///////////////////////////////////////////////////////////////
uint32_t    adc_read_an13(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN13, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };    
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}

unsigned int	vol_yomi(void)
{
unsigned short	sa;

	vol_level=adc_read_an13();
	if(vol_level>vol_level_m){
		sa=vol_level-vol_level_m;
	}
	if(vol_level<=vol_level_m){
		sa=vol_level_m-vol_level;
	}
	if(sa>=10){
		vol_level_m=vol_level;
	}
	else{
		vol_level=vol_level_m;
	}
	vol_level=vol_level/FREQ_MANUAL_DIV;
	vol_level=vol_level+VOLUME_MIN;

	return vol_level;
}

//***************************************************************
//I2C
//***************************************************************
void	i2c_vol_write(unsigned char number_bytes,unsigned char *data)
{
    I2C1_Write(I2C_VOL_ADDR,data,number_bytes);
    while(I2C1_IsBusy()==true);    
    delay_us(5000);  
}

void	i2c_vol_read(unsigned char number_bytes,unsigned char *data)
{
    I2C1_Read(I2C_VOL_ADDR,data,number_bytes);
    while(I2C1_IsBusy()==true);
}

void    i2c_volume_set(void)
{
   unsigned char   wdata[5];
   
   wdata[0]=0x00;
   wdata[1]=0x00;
   wdata[2]=0x80 | (unsigned char)volume_no;
   wdata[3]=0x80 | (unsigned char)volume_no;
   I2C1_Write(I2C_VOL_ADDR,wdata,4);
   while(I2C1_IsBusy()==true);
}
// *****************************************************************************

// *****************************************************************************
int main ( void )
{

    /* Initialize all modules */
    SYS_Initialize ( NULL );
    GPIO_PinWrite(MUTE,1);
    set_up();

    vram_clear(3);

    disp_main2();

    delay_ms(2000);    

    pal_no=1;
    pal_color_set();

    GPIO_PinWrite(MUTE,0);    
    adc_data=0;
    
    mode=1;
	volume_no=VOLUME_MIN;
	vol_count=0;
	volume_no_m=VOLUME_MAX;    
    
    vram_clear(7);
    vram_set_hpamp(8,0);
    disp_main2();
    
    vram_set_suji_db(0,14,volume_no);
    vram_set_db(48,22);
    i2c_volume_set();

	volume_no=vol_yomi();
	if(volume_no>VOLUME_MAX){volume_no=VOLUME_MAX;}
    
    vram_set_suji_db(0,14,volume_no);
    i2c_volume_set();
    
	volume_no_m=volume_no;

    disp_main2();

    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        //SYS_Tasks ( );
        /* key scan 1 */
		//if (GPIO_PinRead(SW1)==0){
		//		sw1_key=0;
		//}
		//else{
		//	sw1_key=1;
		//	sw1_rep=0;
		//	sw1_cnt=0;
		//}
		/*------------------*/
		//if (GPIO_PinRead(SW2)==0){
		//		sw2_key=0;
		//}
		//else{
		//	sw2_key=1;
		//	sw2_rep=0;
		//	sw2_cnt=0;
		//}
		/*------------------*/        
		//if (GPIO_PinRead(SW3)==0){
		//		sw3_key=0;
		//}
		//else{
		//	sw3_key=1;
		//	sw3_rep=0;
		//	sw3_cnt=0;
		//}
		/*------------------*/         
        
        vram_set_suji_db(0,14,volume_no);

        /*------------------*/
        /* key scan 2 */
		//if ((GPIO_PinRead(SW1)==0)&&(sw1_key==0)){
		//	sw1_key=0;
		//}
		//else{
		//	sw1_key=1;
		//	sw1_rep=0;
		//	sw1_cnt=0;
		//}
		/*------------------*/        
		//if ((GPIO_PinRead(SW2)==0)&&(sw2_key==0)){
		//	sw2_key=0;
		//}
		//else{
		//	sw2_key=1;
		//	sw2_rep=0;
		//	sw2_cnt=0;
		//}
		/*------------------*/ 
		//if ((GPIO_PinRead(SW3)==0)&&(sw3_key==0)){
		//	sw3_key=0;
		//}
		//else{
		//	sw3_key=1;
		//	sw3_rep=0;
		//	sw3_cnt=0;
		//}
		/*------------------*/ 
        
        /* key action */  
		//if((sw1_key==0)&&(sw1_rep==0)){
        //    sw1_rep=1;
        //    vram_set_phono(12,0);
        //    disp_main2();
		//}

        /*------------------*/
		//if((sw2_key==0)&&(sw2_rep==0)){
        //    sw2_rep=1;
        //    vram_set_dac(12,0);
        //    disp_main2();
		//}
        /*------------------*/
		//if((sw3_key==0)&&(sw3_rep==0)){
        //    sw3_rep=1;
        //    vram_set_fm(12,0);
        //    disp_main2();
		//}
        /*------------------*/
        
		//**************************
		if(mode==1){
		/*----------*/
			if(vol_count>0){vol_count--;}
			if(vol_count==0){
				volume_no=vol_yomi();
				if(volume_no>VOLUME_MAX){volume_no=VOLUME_MAX;}				

				if(volume_no_m!=volume_no){
                    vram_set_suji_db(0,14,volume_no);
                    i2c_volume_set();
					volume_no_m=volume_no;

                    disp_main2();
				}
				vol_count=VOL_COUNT_SET;
            
                
                //dc12v_level=adc_read_an10();
                //if(dc12v_level<800){
                //    GPIO_PinWrite(SP_CONT,0);
                //}
			}
		}
		/*------------------ */

        /*------------------*/        
        /* Execution should not come here during normal operation */
    }
    //return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

