/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include <cp0defs.h>

#define     LCD_RST     GPIO_PIN_RB7      //RB7 //7
#define     LCD_CS      GPIO_PIN_RB5      //RB5 //5
#define     LCD_WR      GPIO_PIN_RB3      //RB3 //3
#define     LCD_DC      GPIO_PIN_RB6      //RB6 //6
#define     LCD_RD      GPIO_PIN_RB2      //RB2 //2

#define     SW1         GPIO_PIN_RB9
#define     SW2         GPIO_PIN_RB10

#define     TIME_DOWN_INIT  150
#define     NEXT_COUNT_INIT 40

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************
unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;
unsigned char	sw2_key;
unsigned char	sw2_rep;
unsigned char	sw2_cnt;

unsigned int    capture_data;
unsigned char   int1_flg;

unsigned char   pal_no;

unsigned char   vram[6400];

unsigned char color_data1_init[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2_init[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char color_data1[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,1};
unsigned char color_data2[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char   pal_color[8][16]={
    {0,1,2,3,4,5,6,7,8,9,10,11,1,13,14,15},     //0
    {7,6,2,14,4,3,6,0,8,11,10,12,12,13,14},      //1
    {0,2,2,9,4,11,6,4,8,12,10,3,12,13,14},      //2
    {7,13,2,14,4,9,6,12,8,11,10,15,12,13,14},      //3
    {0,9,2,14,4,3,6,8,8,12,10,1,12,13,14},   //4
    {0,12,2,9,4,1,6,6,8,11,10,3,12,13,14},     //5
    {0,7,2,7,4,7,6,0,8,7,10,7,12,13,14},     //6
    {0,0,2,0,4,0,6,7,8,0,10,0,12,13,14},     //7
};

const   unsigned char   font_moji_o[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,16,119,119,0,17,119,7,16,17,119,7,17,17,119,0,17,17,119,16,17,17,119,16,17,17,7,16,17,17,7,17,17,17,7,17,17,17,7,17,17,17,7,17,17,17,7,17,17,17,7,17,17,17,7,17,17,17,7,17,17,17,7,16,17,17,119,0,17,17,119,7,0,17,119,119,7,0,119,119,119,119,},
{119,119,119,119,7,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,1,0,17,17,0,7,16,1,112,119,16,1,119,119,16,1,119,7,16,1,119,7,17,1,112,0,17,17,0,16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,1,0,0,0,0,119,119,119,119,},
{119,119,119,119,0,119,119,119,1,0,112,119,17,17,0,119,17,17,1,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,1,112,17,17,1,119,17,17,1,119,17,17,0,119,17,17,112,119,17,1,112,119,17,0,119,119,0,112,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_p[3][96]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,16,17,119,119,16,17,119,7,16,17,119,7,17,17,119,7,17,17,119,7,17,17,119,0,17,17,119,16,17,17,119,16,17,17,119,16,17,17,119,16,17,17,7,16,17,17,7,17,17,17,7,17,17,17,7,17,17,17,0,17,17,17,16,17,17,17,16,17,17,17,16,17,17,17,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,1,0,0,17,1,119,7,17,0,119,0,17,112,7,16,17,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,1,0,0,0,1,119,119,119,1,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,119,17,17,1,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,1,112,17,17,1,119,17,17,1,119,17,17,0,119,17,1,112,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_t[3][96]={
{119,119,119,119,119,119,119,119,119,119,7,0,119,119,7,17,119,119,0,17,119,119,16,17,119,119,16,17,119,119,16,17,119,119,16,17,119,119,0,0,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,16,119,119,119,16,119,119,7,16,119,119,7,17,119,119,7,17,119,119,7,17,119,119,7,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,17,17,17,16,17,17,17,16,17,17,17,17,17,17,17,17,17,17,1,17,17,17,1,17,17,17,1,17,17,17,1,17,17,17,0,17,17,17,112,17,17,17,112,17,17,17,112,17,17,17,112,0,0,0,112,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,17,17,17,112,17,17,17,112,17,17,17,112,17,17,1,112,17,17,0,119,17,17,112,119,0,0,112,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_u[3][96]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,144,153,119,119,144,153,119,119,144,153,119,7,144,153,119,7,153,153,119,7,153,153,119,7,153,153,119,0,153,153,119,144,153,153,119,144,153,153,7,144,153,153,7,153,153,153,7,153,153,153,7,153,153,153,7,153,153,153,7,153,153,153,7,144,153,153,119,144,153,153,119,0,144,153,119,119,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,112,7,153,153,112,7,153,153,112,7,153,9,112,7,153,9,119,0,153,9,119,144,153,9,119,144,153,0,119,144,153,112,7,144,153,112,7,153,9,112,7,153,9,119,7,153,9,119,7,153,9,112,0,153,153,0,144,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,9,112,153,153,9,119,153,153,9,119,153,153,9,119,153,153,9,119,153,153,0,119,153,153,112,119,153,153,112,119,153,153,112,119,153,9,112,119,153,9,119,119,153,0,119,119,9,112,119,119,0,119,119,119,112,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_s[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,144,119,119,0,153,119,119,144,153,119,7,144,153,119,7,153,153,119,7,153,153,119,7,153,153,119,7,153,153,119,7,153,153,119,7,153,153,119,7,144,153,119,119,0,0,119,0,0,119,7,144,9,0,7,153,153,153,7,153,153,153,7,153,153,153,7,153,153,153,7,0,153,153,119,7,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,9,0,153,153,0,119,153,153,0,0,153,153,153,153,153,153,153,153,153,153,153,153,0,0,144,153,119,7,144,153,0,0,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,9,112,0,0,0,119,119,119,119,119,0,0,119,119,153,9,112,119,153,153,112,119,153,153,112,119,153,153,112,119,153,153,112,119,153,153,112,119,153,153,112,119,153,9,112,119,153,9,119,119,153,0,119,119,0,112,119,119,112,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_b[3][96]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,144,153,119,119,144,153,119,7,144,153,119,7,153,153,119,7,153,153,119,7,153,153,119,0,153,153,119,144,153,153,119,144,153,153,119,144,153,153,7,144,153,153,7,153,153,153,7,153,153,153,0,153,153,153,144,153,153,153,144,153,153,153,144,153,153,153,144,153,153,153,0,153,153,153,7,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,0,0,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,9,0,144,153,0,7,144,153,0,0,153,153,153,153,153,153,153,153,153,153,153,153,153,153,0,0,153,9,112,0,153,9,0,144,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,112,119,153,153,0,119,153,153,9,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,153,112,153,153,9,112,153,0,0,119,153,153,0,119,153,153,9,119,153,153,9,119,153,153,9,119,153,153,9,119,153,153,0,119,153,153,112,119,153,9,112,119,0,0,119,119,112,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_dot[2][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,0,51,119,119,7,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,3,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,3,112,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
};
const   unsigned char   font_moji_sp[3][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,},    
};

const   unsigned char   font_moji_kh1[3][96]={
{119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,176,119,119,119,176,119,119,119,176,119,119,7,176,119,119,7,187,119,119,7,187,119,119,7,187,119,119,0,187,119,119,176,187,119,119,176,187,119,119,176,187,119,7,176,187,119,7,187,187,119,7,187,187,119,7,187,187,119,0,187,187,119,176,187,187,119,176,187,187,119,0,0,0,119,119,119,119,},
{119,119,119,119,0,0,0,0,187,187,187,11,187,187,187,11,187,187,187,11,187,187,187,0,187,187,187,0,187,187,187,0,187,187,11,176,187,187,11,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,11,187,187,187,11,187,187,187,11,176,187,187,11,176,187,187,0,176,187,187,112,0,187,0,112,7,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,176,187,187,187,187,187,187,187,187,187,187,11,187,187,187,0,187,187,11,0,187,187,0,7,187,11,112,7,187,0,119,7,187,0,119,0,187,11,119,176,187,11,119,176,187,11,112,176,187,187,112,176,187,187,0,176,187,187,0,187,187,187,0,187,0,0,0,0,119,119,119,119,},
};
const   unsigned char   font_moji_kh2[3][96]={
{119,119,119,119,119,119,119,119,7,0,0,0,7,187,187,187,7,187,187,187,0,187,187,187,0,187,187,187,176,187,187,187,176,187,187,187,176,187,187,187,176,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,11,187,187,187,11,187,187,187,0,187,187,187,112,187,187,187,112,187,187,187,112,187,187,11,112,0,0,0,119,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,112,0,0,187,112,176,187,187,112,176,187,11,112,176,187,11,7,176,187,11,7,187,187,0,7,187,187,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,187,187,187,7,187,187,187,7,187,187,187,0,187,187,187,176,187,187,187,176,187,187,187,176,187,187,187,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,0,0,112,119,187,187,112,119,187,187,112,119,187,187,0,0,187,187,0,187,187,187,0,187,187,11,176,187,187,11,176,187,187,11,176,187,187,11,176,187,187,0,0,0,187,112,119,0,187,112,7,176,187,112,0,187,11,0,176,187,11,176,187,187,11,176,187,187,11,176,187,187,0,176,187,187,112,176,187,187,112,0,0,0,119,119,119,119,},
};
const   unsigned char   font_moji_kh3[2][96]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,176,187,187,187,187,187,187,187,187,187,187,11,187,187,187,0,187,187,11,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0,119,119,119,119,},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,187,112,119,187,11,112,119,187,0,119,119,11,112,119,119,0,119,119,119,119,119,119,119,0,112,119,119,187,112,119,119,187,112,119,119,187,112,119,119,11,112,119,119,11,119,119,119,0,119,119,119,119,119,119,119,},
};

const   unsigned char   font_suji_0[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,85,119,7,80,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,7,80,85,85,119,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,112,119,85,85,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,5,112,85,85,0,119,85,85,112,119,85,5,112,119,5,0,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_1[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,0,0,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,119,85,85,0,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,85,112,119,85,5,112,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_2[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,7,0,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,0,0,0,112,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,80,119,119,7,80,119,119,0,85,119,7,80,85,119,7,85,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,112,119,85,85,0,119,85,85,5,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,112,85,5,0,119,85,0,119,119,85,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_3[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,119,119,0,85,119,7,80,85,7,0,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,0,0,0,112,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,0,119,119,119,7,119,119,119,119,0,0,0,119,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,0,85,85,119,7,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,5,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,0,112,5,0,112,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_4[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,7,80,85,119,7,85,85,119,0,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,5,80,85,85,5,80,85,85,5,80,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,5,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,5,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,0,112,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_5[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,7,0,0,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,7,85,85,85,7,85,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,80,119,119,119,0,119,119,119,7,119,119,119,119,0,119,119,119,5,112,119,7,85,112,119,7,85,0,112,0,85,85,0,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,0,0,0,0,119,119,119,112,119,119,119,0,0,0,119,85,85,5,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,0,112,85,0,112,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_6[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,80,119,119,7,80,119,119,0,85,119,7,80,85,119,7,85,85,119,0,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,5,0,85,85,5,119,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,7,0,85,85,119,7,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,5,112,85,85,5,119,85,85,0,119,85,5,112,119,85,0,119,119,85,112,119,119,5,0,0,112,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,5,112,85,85,5,119,85,85,0,119,5,0,112,119,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,0,119,119,5,112,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_7[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,7,119,119,119,0,119,119,7,80,119,119,7,85,119,119,7,85,119,119,0,85,119,119,80,85,119,7,80,85,119,7,85,85,119,7,85,85,119,0,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,0,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,5,112,85,85,5,119,85,85,0,119,85,85,112,119,85,85,112,119,85,85,112,119,85,5,112,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_8[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,0,119,119,119,80,119,119,7,80,119,119,7,85,119,119,0,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,80,85,119,119,0,85,119,119,7,80,119,119,119,0,119,119,119,7,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,7,80,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,112,85,85,5,112,85,85,5,119,85,85,5,119,85,85,5,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,0,80,85,85,119,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,0,80,85,85,119,80,85,85,0,80,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,0,112,0,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,112,119,119,119,0,119,119,119,5,119,119,119,5,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_9[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,0,119,119,119,80,119,119,119,80,119,119,7,80,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,85,119,119,7,80,119,119,119,80,119,119,119,80,119,119,119,0,119,119,119,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,7,119,119,119,0,119,119,119,80,119,119,7,80,119,119,0,85,119,119,80,85,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,7,80,85,119,0,85,85,7,80,85,85,0,85,85,85,80,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,112,85,85,85,112,85,85,85,0,85,85,85,5,85,85,85,5,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,80,85,85,85,80,85,85,85,0,0,0,80,119,119,0,85,119,119,80,85,119,7,80,85,119,0,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,119,85,85,5,112,85,85,85,0,85,85,85,5,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,85,85,85,7,80,85,85,119,80,85,85,119,80,85,85,7,80,85,85,7,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,5,85,85,85,5,85,85,85,0,85,85,85,112,85,85,5,112,85,85,5,119,85,85,0,119,85,5,112,119,85,0,119,119,85,112,119,119,5,112,119,119,0,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,119,119,119,112,119,119,119,112,119,119,119,0,119,119,119,5,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,0,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,5,119,119,85,0,119,119,85,112,119,119,85,112,119,119,85,112,119,119,85,112,119,119,5,112,119,119,5,119,119,119,5,119,119,119,0,119,119,119,112,119,119,119,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_space[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};
const   unsigned char   font_suji_bar[4][192]={
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,48,51,119,119,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
{119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,51,112,119,119,0,112,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119},
};

const unsigned char font_suji_8_dot[32]={7,0,0,112,0,85,85,0,80,85,85,5,80,85,85,5,80,85,85,5,80,85,85,5,0,85,85,0,7,0,0,112,};

//unsigned char test_moji1[20]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
//unsigned char test_moji2[26]={10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35};

// delay
#define CCLK			(9600000L)
#define PBCLK		(CCLK / 2)
#define SAMPLE_RATE	5000
#define CCLK_US		(PBCLK / 100 / 1000)
#define CCLK_MS		(PBCLK / 100)

void delay_us(unsigned int  d) 
{
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();     
	delayCount = d * CCLK_US; 
	while((_CP0_GET_COUNT() - startTime) < delayCount);  
 }

void delay_ms(unsigned int d)
{   
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();   
	delayCount = d * CCLK_MS;   
	while((_CP0_GET_COUNT() - startTime) < delayCount);   
}

void    send_cmd(unsigned char cmd)
{
    GPIO_PinWrite(LCD_DC,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)cmd);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data(unsigned char data)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_2(unsigned char data1,unsigned char data2)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_4(unsigned char data1,unsigned char data2,unsigned char data3,unsigned char data4)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data3);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data4);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}


void    set_up(void)
{
    GPIO_PinWrite(LCD_RST,1);
    delay_us(10);
    GPIO_PinWrite(LCD_WR,0);
    delay_us(10);
    GPIO_PinWrite(LCD_RD,1);
    delay_us(10);    
    GPIO_PinWrite(LCD_CS,0);
    delay_us(10);
    
    send_cmd(0x3a);
    send_data(0x05);    
    
    send_cmd(0xb1);
    send_data(0x05);
    send_data(0x3c);    
    send_data(0x3c);      

    send_cmd(0xb2);
    send_data(0x05);
    send_data(0x3c);  
    send_data(0x3c);      
    
    send_cmd(0xb3);
    send_data(0x05);
    send_data(0x3c); 
    send_data(0x3c); 

    send_cmd(0xb4);
    send_data(0x03);    
    
    send_cmd(0xc0);
    send_data(0xe0);
    send_data(0x00);
    send_data(0x84);    

    send_cmd(0xc1);
    send_data(0x05);
    
    send_cmd(0xc2);
    send_data(0x0d);
    send_data(0x00);   

    send_cmd(0xc3);
    send_data(0x8d);
    send_data(0xea);   

    send_cmd(0xc4);
    send_data(0x8d);
    send_data(0xee);
    
    send_cmd(0xc5);
    send_data(0x03);    
    
    send_cmd(0xc7);
    send_data(0x0a);  

    send_cmd(0x36);
    send_data(0x68);        //c8

    send_cmd(0xe0);
    send_data(0x1b);
    send_data(0x1a);
    send_data(0x10);
    send_data(0x15);
    send_data(0x34);
    send_data(0x2e);
    send_data(0x2a);
    send_data(0x2a);
    send_data(0x2c);
    send_data(0x27);
    send_data(0x2e);
    send_data(0x39);
    send_data(0x00);
    send_data(0x15);
    send_data(0x02);
    send_data(0x3f);

    send_cmd(0xe1);
    send_data(0x1a);
    send_data(0x1a);
    send_data(0x0f);
    send_data(0x15);
    send_data(0x34);
    send_data(0x2e);
    send_data(0x25);
    send_data(0x2b);
    send_data(0x26);
    send_data(0x26);
    send_data(0x2f);
    send_data(0x3a);
    send_data(0x00);
    send_data(0x15);
    send_data(0x02);
    send_data(0x3f);

    send_cmd(0x11);
    delay_ms(130);    

    send_cmd(0x29);
    delay_ms(100);
    
    send_cmd(0x2a);
    send_data_4(0x00,0x00,0x00,0x9f);       //0x00,0x18,0x00,0x67
    
    send_cmd(0x2b);
    send_data_4(0x00,0x18,0x00,0x68);       //0x00,0x00,0x00,0x9f  
}

void    disp_main2(void)
{
    unsigned int    i;
    unsigned char   data1,data2;

            GPIO_PinWrite(GPIO_PIN_RE5,1);
            send_cmd(0x2a);
            send_data_4(0x00,0x00,0x00,0x9f);       //0x00,0x18,0x00,0x67
            send_cmd(0x2b);
            send_data_4(0x00,0x18,0x00,0x68);       //0x00,0x00,0x00,0xa0 
            send_cmd(0x2c);
    
            GPIO_PinWrite(LCD_DC,1);
            
            for (i=0;i<6400;i++){
                data2=vram[i] >> 4;
                data1=vram[i] & 0x0f;
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data1];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data2];
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                *(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) = (*(volatile uint32_t *)(&LATB + (((GPIO_PORT)(LCD_WR>>4)) * 0x40)) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
            }
            GPIO_PinWrite(GPIO_PIN_RE5,0);                
}
void    test_vram(void)
{
    unsigned int    i;
    
    for(i=0;i<6400/2;i++){
        vram[i*2]=0x13;
        vram[i*2+1]=0x45;
    }
}

void    vram_clear(unsigned char color)
{
    unsigned int i;
    unsigned char data;
    
    data=(color << 4) | color;
    
    for(i=0;i<6400;i++){
        vram[i]=data;
    }
}

void    vram_set_sp(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_sp[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_sp[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }    
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_sp[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }       
}
void    vram_set_usb(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_u[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_s[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }    
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_b[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }       
}
void    vram_set_opt(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_o[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_p[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }    
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_t[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }       
}
void    vram_set_khz(unsigned  int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j,k;
    unsigned int    offset;

    offset=0;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_kh1[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }
    offset=offset+12;
    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_kh2[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }    
    offset=offset+12;
    for(k=0;k<2;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=font_moji_kh3[k][j*4+i];
                vram[k*4+xx+offset+i+(yy*2+j)*80]=data;
                }
            }
    }        
    
}
void    vram_set_8_dot(unsigned int xx,unsigned int yy)
{
    unsigned char   data;
    unsigned int    i,j;
    
    for(j=0;j<8;j++){
        for(i=0;i<4;i++){
            data=font_suji_8_dot[j*4+i];
            vram[xx+i+(yy*2+j)*80]=data;
        }
    }
}
void    vram_set_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned int    i,j,k;
    
    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_0[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_1[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_2[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_3[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_4[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_5[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_6[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 7:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_7[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 8:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_8[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 9:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_9[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 10:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_space[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;
        case 11:
            for(k=0;k<4;k++){
                for(j=0;j<48;j++){
                    for(i=0;i<4;i++){
                        data=font_suji_bar[k][j*4+i];
                        vram[k*4+xx+i+(yy*2+j)*80]=data;
                    }
                }
            }
            break;            
    }
}

void    vram_set_test_capture_data_n5(unsigned int data)
{
    unsigned char   n0,n1,n2,n3,n4;
    unsigned int    count;
    
    count=data;
    
    n0=(unsigned char)(count%10);count=(count-n0)/10;
	n1=(unsigned char)(count%10);count=(count-n1)/10;
	n2=(unsigned char)(count%10);count=(count-n2)/10;
    n3=(unsigned char)(count%10);count=(count-n3)/10;
    n4=(unsigned char)(count%10);

    vram_set_suji(0,14,n4);
    vram_set_suji(16,14,n3);
    vram_set_suji(32,14,n2);
    vram_set_suji(48,14,n1);
    vram_set_suji(64,14,n0);
}
void    vram_set_capture_data_disp(unsigned int data)
{
    vram_set_suji(0,14,11);
    vram_set_suji(16,14,11);
    vram_set_suji(32,14,11);
    
    if((data>=235)&&(data<=265)){
        vram_set_suji(0,14,3);
        vram_set_suji(16,14,8);
        vram_set_suji(32,14,4);
    }
    if((data>=485)&&(data<=515)){
        vram_set_suji(0,14,1);
        vram_set_suji(16,14,9);
        vram_set_suji(32,14,2);
    }
    if((data>=530)&&(data<=560)){
        vram_set_suji(0,14,1);
        vram_set_suji(16,14,7);
        vram_set_suji(32,14,6);
    }
    if((data>=985)&(data<=1015)){
        vram_set_suji(0,14,9);
        vram_set_suji(16,14,6);
        vram_set_8_dot(28,34);
        vram_set_suji(32,14,0);
    }
    if((data>=1073)&&(data<=1103)){
        vram_set_suji(0,14,8);
        vram_set_suji(16,14,8);
        vram_set_8_dot(28,34);
        vram_set_suji(32,14,2);        
    }
    if((data>=1985)&&(data<=2015)){
        vram_set_suji(0,14,4);
        vram_set_suji(16,14,8);
        vram_set_8_dot(28,34);
        vram_set_suji(32,14,0);    
    }
    if((data>=2162)&&(data<=2192)){
        vram_set_suji(0,14,4);
        vram_set_suji(16,14,4);
        vram_set_8_dot(28,34);
        vram_set_suji(32,14,1);        
    }
}
void    pal_color_set(void)
{
    unsigned int i;
    
    for (i=0;i<16;i++){
        color_data1[i]=color_data1_init[pal_color[pal_no][i]];
        color_data2[i]=color_data2_init[pal_color[pal_no][i]];
    }
}

// *****************************************************************************

// *****************************************************************************
int main ( void )
{

    /* Initialize all modules */
    SYS_Initialize ( NULL );

    set_up();

    pal_no=0;
    pal_color_set();
    
    vram_clear(7);
    vram_set_suji(0,14,11);
    vram_set_suji(16,14,11);
    vram_set_suji(32,14,11);
    vram_set_khz(48,26);
    
    disp_main2();
    
    capture_data=0;
    int1_flg=0;

    EVIC_SourceEnable(INT_SOURCE_EXTERNAL_1);
    TMR2_Start();
    
    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        //SYS_Tasks ( );
        /* key scan 1 */
		if (GPIO_PinRead(SW1)==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
		if (GPIO_PinRead(SW2)==0){
				sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/        
        
        //vram_set_suji(32,14,0);
        
        if(int1_flg==1){
            vram_set_capture_data_disp(capture_data);
            int1_flg=0;
        }

        disp_main2();

        /*------------------*/
        /* key scan 2 */
		if ((GPIO_PinRead(SW1)==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/        
		if ((GPIO_PinRead(SW2)==0)&&(sw2_key==0)){
			sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/ 
        
        /* key action */  
		if((sw1_key==0)&&(sw1_rep==0)){
            sw1_rep=1;
            pal_no++;
            if(pal_no>7){
                pal_no=0;
            }
            pal_color_set();
		}
        /*------------------*/
        if(sw2_key==0){
            vram_set_opt(0,0);
            vram_set_sp(44,0);
        }
        else{
            vram_set_sp(0,0);
            vram_set_usb(44,0);            
        }

        /*------------------*/        
        /* Execution should not come here during normal operation */
    }
    //return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

