/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include <cp0defs.h>

#define     LCD_RST         GPIO_PIN_RB7      //RB7 //7
#define     LCD_CS          GPIO_PIN_RB5      //RB5 //5
#define     LCD_WR          GPIO_PIN_RB3      //RB3 //3
#define     LCD_DC          GPIO_PIN_RB6      //RB6 //6
#define     LCD_RD          GPIO_PIN_RB2      //RB2 //2

#define     DDS_SDATA       GPIO_PIN_RB10
#define     DDS_SCLK        GPIO_PIN_RB11
#define     DDS_FSYNC       GPIO_PIN_RB12

#define		LEVEL_DATA_P  	GPIO_PIN_RF1
#define		LEVEL_CLK		GPIO_PIN_RF0

#define     SW4             GPIO_PIN_RG2
#define     SW3             GPIO_PIN_RG3
#define     SW2             GPIO_PIN_RB14
#define     SW1             GPIO_PIN_RB15

#define     TEST            GPIO_PIN_RG2

#define     AD9834_SIG_ON_DATA      0x2008
#define     AD9834_SIG_OFF_DATA     0x2048

#define     KEY_LONG_UD             20
#define     KEY_LONG_PUSH           50

#define		FREQ_MIN				20
#define		FREQ_MAX				20000
#define		VOL_COUNT_SET			10
#define     LEVEL_COUNT_SET         10
#define     SWEEP_LOOP_INIT         40

//#define     GRAPH_LINE_COLOR        10      //graph_color[graph_color_set][0]
//#define     GRAPH_POINT_COLOR       12      //graph_color[graph_color_set][1]
//#define     GRAPH_WAKU_DOT_COLOR    13      //graph_color[graph_color_set][2]
//#define     GRAPH_WAKU_LINE_COLOR   11      //graph_color[graph_color_set][3]

#define     GRAPH_COLOR_SET_INIT    3           //0-3

//#define     I2C_EEPROM      0x50

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************
uint32_t        adc_data[14];

unsigned char   mode;
unsigned char   db_mode;
unsigned char   db_pointa1;
unsigned char   db_pointa2;
unsigned char   db_pointa3;

unsigned char   hz_mode;

unsigned char   lcdmode;

unsigned long   freq_data;
unsigned char   freq_out;
unsigned long	freq_data_m;

unsigned char   range;
unsigned int	vol_count;

uint32_t    	vol_level;
uint32_t        vol_level_m;
uint32_t        vol_data;
unsigned int    vol_step;
unsigned int    disp_step;
unsigned int    disp_step_m;

unsigned int    level_count;
uint32_t        level_data;
uint32_t        level_st[5];
unsigned int    level_st_count;

unsigned char   sweep_flg;
unsigned int    sweep_count;
unsigned int    sweep_loop;

unsigned char   graph_color_set;
unsigned char   graph_color[4][4]={
    {10,12,13,11},
    {5,7,4,6},
    {12,6,9,2},
    {13,8,5,7}
};

unsigned char   color_data1[16]={0,248,7,0,255,248,7,255,127,120,7,251,248,3,123,3};
unsigned char   color_data2[16]={0,0,224,31,224,31,255,255,224,31,239,224,15,255,239,224};

unsigned char	sw1_key;
unsigned char	sw1_rep;
unsigned char	sw1_cnt;
unsigned char	sw2_key;
unsigned char	sw2_rep;
unsigned char	sw2_cnt;
unsigned char	sw3_key;
unsigned char	sw3_rep;
unsigned char	sw3_cnt;
unsigned char	sw4_key;
unsigned char	sw4_rep;
unsigned char	sw4_cnt;
unsigned char   sw4_loop;

unsigned char   db_retu_1[8]={0,2,8,14,20,22,24,26};
unsigned char   db_retu_2[16]={0,28,30,3,6,8,10,13,15,18,20,32,34,35,37,24};
unsigned char   db_retu_3[31]={0,27,28,29,30,2,3,4,6,7,8,9,10,12,13,14,15,16,18,19,20,31,32,33,34,22,35,36,37,38,24};
unsigned char   db_retu_4[13]={0,1,2,5,8,11,14,17,20,21,22,23,24};

unsigned int    sweep_hz_step0[159]={
20,30,40,50,60,70,80,90,100,110,
120,130,140,150,160,170,180,190,200,210,
220,230,240,250,260,270,280,290,300,310,
320,330,340,350,360,370,380,390,400,410,
420,430,440,450,460,470,480,490,500,520,
540,560,580,600,620,640,660,680,700,720,
740,760,780,800,820,840,860,880,900,920,
940,960,980,1000,1100,1200,1300,1400,1500,1600,
1700,1800,1900,2000,2100,2200,2300,2400,2500,2600,
2700,2800,2900,3000,3100,3200,3300,3400,3500,3600,
3700,3800,3900,4000,4100,4200,4300,4400,4500,4600,
4700,4800,4900,5000,5200,5400,5600,5800,6000,6200,
6400,6600,6800,7000,7200,7400,7600,7800,8000,8200,
8400,8600,8800,9000,9200,9400,9600,9800,10000,11000,
12000,13000,14000,15000,16000,17000,18000,19000,20000,21000,
22000,23000,24000,25000,26000,27000,28000,29000,30000
};
unsigned int    sweep_x_step0[159]={
24,40,52,60,68,74,79,84,88,91,
95,98,101,104,106,109,111,113,115,117,
119,120,122,124,125,127,128,130,131,132,
133,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,149,150,151,153,
154,155,157,158,159,161,162,163,164,165,
166,167,168,169,170,171,172,173,174,175,
176,177,177,178,182,185,189,191,194,197,
199,201,203,205,207,209,211,213,214,216,
217,219,220,221,223,224,225,226,227,229,
230,231,232,233,234,235,236,236,237,238,
239,240,241,241,243,245,246,247,249,250,
251,252,254,255,256,257,258,259,260,261,
262,263,264,265,265,266,267,268,269,272,
276,279,282,285,287,290,292,294,296,298,
300,301,303,305,306,308,309,311,312
};

unsigned int    sweep_hz_step1[74]={
20,30,40,50,60,70,80,90,100,110,
120,130,140,150,160,170,180,190,200,210,
220,230,240,250,260,270,280,290,300,310,
320,330,340,350,360,370,380,390,400,410,
420,430,440,450,460,470,480,490,500,520,
540,560,580,600,620,640,660,680,700,720,
740,760,780,800,820,840,860,880,900,920,
940,960,980,1000
};
unsigned int    sweep_x_step1[74]={
24,52,72,88,100,111,120,128,136,142,
148,154,159,164,168,173,177,180,184,187,
191,194,197,199,202,205,207,210,212,214,
217,219,221,223,225,227,229,230,232,234,
236,237,239,240,242,243,245,246,248,250,
253,256,258,260,263,265,267,269,271,273,
275,277,279,280,282,284,285,287,288,290,
292,293,294,296
};

unsigned int    sweep_hz_step2[66]={
100,110,
120,130,140,150,160,170,180,190,200,210,
220,230,240,250,260,270,280,290,300,310,
320,330,340,350,360,370,380,390,400,410,
420,430,440,450,460,470,480,490,500,520,
540,560,580,600,620,640,660,680,700,720,
740,760,780,800,820,840,860,880,900,920,
940,960,980,1000
};
unsigned int    sweep_x_step2[66]={
25,36,
46,56,65,73,80,87,94,101,107,112,
118,123,128,133,137,142,146,150,154,158,
162,166,169,172,176,179,182,185,188,191,
194,197,199,202,205,207,210,212,214,219,
224,228,232,236,240,244,247,251,254,257,
261,264,267,270,273,276,278,281,284,286,
289,291,294,296
};

unsigned int    sweep_hz_step3[66]={
1000,1100,1200,1300,1400,1500,1600,
1700,1800,1900,2000,2100,2200,2300,2400,2500,2600,
2700,2800,2900,3000,3100,3200,3300,3400,3500,3600,
3700,3800,3900,4000,4100,4200,4300,4400,4500,4600,
4700,4800,4900,5000,5200,5400,5600,5800,6000,6200,
6400,6600,6800,7000,7200,7400,7600,7800,8000,8200,
8400,8600,8800,9000,9200,9400,9600,9800,10000
};
unsigned int    sweep_x_step3[66]={
24,35,46,55,64,72,80,
87,93,100,106,112,117,122,127,132,137,
141,146,150,154,158,161,165,169,172,175,
179,182,185,188,191,194,196,199,202,204,
207,209,212,214,219,223,228,232,236,240,
243,247,250,254,257,260,264,267,270,273,
275,278,281,284,286,289,291,294,296
};

unsigned int    sweep_disp_step0[100]={
0,2,4,6,8,10,12,14,16,18,
20,22,24,26,28,30,32,34,36,38,
40,42,44,46,48,49,50,51,52,53,
54,55,56,57,58,59,60,61,62,63,
64,65,66,67,68,69,70,71,72,73,
75,77,79,81,83,85,87,89,91,93,
95,97,99,101,103,105,107,109,111,113,
114,115,116,117,118,119,120,121,122,123,
124,125,126,127,128,129,130,131,132,133,
134,135,136,137,138,140,142,144,146,148,
};
unsigned int    sweep_disp_step1[100]={
0,1,1,2,3,4,4,5,6,6,
7,8,9,9,10,11,12,12,13,14,
15,15,16,17,18,18,19,20,20,21,
22,23,23,24,25,26,26,27,28,29,
29,30,31,31,32,33,34,34,35,36,
37,37,38,39,40,40,41,42,42,43,
44,45,45,46,47,48,48,49,50,51,
51,52,53,54,54,55,56,56,57,58,
59,59,60,61,62,62,63,64,65,65,
66,67,67,68,69,70,70,71,72,73,
};
unsigned int    sweep_disp_step2[100]={
0,0,1,2,2,3,4,4,5,6,
6,7,8,8,9,10,10,11,12,12,
13,14,14,15,16,16,17,18,18,19,
19,20,21,21,22,23,23,24,25,25,
26,27,27,28,29,29,30,31,31,32,
33,33,34,35,35,36,37,37,38,38,
39,40,40,41,42,42,43,44,44,45,
46,46,47,48,48,49,50,50,51,52,
52,53,54,54,55,56,56,57,57,58,
59,59,60,61,61,62,63,63,64,65,
};
unsigned int    sweep_disp_step3[100]={
0,0,1,2,2,3,4,4,5,6,
6,7,8,8,9,10,10,11,12,12,
13,14,14,15,16,16,17,18,18,19,
19,20,21,21,22,23,23,24,25,25,
26,27,27,28,29,29,30,31,31,32,
33,33,34,35,35,36,37,37,38,38,
39,40,40,41,42,42,43,44,44,45,
46,46,47,48,48,49,50,50,51,52,
52,53,54,54,55,56,56,57,57,58,
59,59,60,61,61,62,63,63,64,65,
};


uint32_t    sweep_level_data[159];


unsigned char   vram1[40000];

const unsigned char font_hz_01_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,112,0,119,119,119,7,119,119,119,7,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,119,119,7,112,119,119,7,112,119,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,119,119,7,119,119,119,7,119,119,119,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,112,0,0,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,119,112,0,0,119,112,0,0,119,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_02_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,119,0,119,119,119,7,119,119,119,7,119,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,119,112,7,112,119,119,7,112,119,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,119,119,7,119,119,119,7,119,119,112,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,112,0,0,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,119,112,0,0,119,112,0,0,119,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_03_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,7,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,119,0,7,112,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,112,0,119,119,119,7,119,119,119,7,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,7,112,119,119,7,119,119,119,7,119,119,112,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,112,0,0,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,119,112,0,0,119,112,0,0,119,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_04_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,119,0,119,119,119,0,119,119,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_05_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,119,0,7,112,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_06_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,112,7,119,119,112,7,119,119,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,112,0,119,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_07_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_08_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_09_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_10_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_11_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_12_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_13_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_14_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,7,119,112,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_15_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_16_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_17_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,7,119,112,0,7,119,112,0,7,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_18_data[3][96]={
{0,0,0,0,0,0,0,0,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,119,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,0,0,7,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_19_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_20_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,0,0,7,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_21_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_hz_22_data[3][96]={
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,0,119,119,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,119,0,119,119,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,112,7,119,119,112,119,119,119,112,112,119,119,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,7,112,0,119,7,112,0,119,7,112,0,119,119,0,0,119,119,112,0,119,7,112,0,119,7,112,0,119,7,112,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,0,0,0,0,0,0,0,0}
};



const unsigned char font_db_01_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,112,119,119,119,112,119,119,119,112,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_02_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,119,0,119,119,119,0,119,119,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_03_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_04_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,7,119,112,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_05_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_06_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,119,0,119,119,119,0,119,119,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_07_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_08_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_09_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_10_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_11_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_12_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,119,0,119,119,119,0,119,119,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,112,119,119,119,112,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_13_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_14_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_15_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,7,119,112,119,7,119,112,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_16_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,7,119,112,119,7,119,112,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_17_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,7,119,112,119,7,119,112,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_18_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,7,119,112,119,7,119,112,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,119,0,119,119,119,0,119,119,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_19_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,7,119,112,119,7,119,112,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_20_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,7,119,112,119,7,119,112,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,7,119,112,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_21_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,119,119,119,7,119,119,119,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,112,119,119,119,112,119,119,119,112,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_22_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,119,119,119,7,119,119,119,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,119,112,119,119,119,112,119,119,119,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,119,112,112,119,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,0,119,0,119,0,119,112,119,119,119,112,119,119,119,112,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_23_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,119,7,112,7,119,7,112,7,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,112,7,0,7,112,7,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_24_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,119,7,112,7,119,7,112,7,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,112,7,0,7,112,7,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,119,112,119,119,119,112,119,119,119,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,119,112,112,119,119,119,112,7,119,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_25_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,119,119,119,7,119,119,119,7,119,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,112,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,112,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_26_data[3][96]={
{0,0,0,0,0,0,0,0,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,112,7,0,7,119,119,119,7,119,119,119,7,119,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,112,7,119,119,112,119,119,119,112,119,119,119,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,119,112,112,119,119,119,112,7,119,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,112,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_27_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,119,7,119,119,119,0,119,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,112,7,0,7,112,7,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,112,7,119,112,112,119,119,119,112,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_28_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,7,119,112,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_29_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_30_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,119,119,0,119,119,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_31_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,0,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_32_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,119,119,119,7,119,119,119,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,7,119,119,112,119,119,119,0,119,119,112,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,112,119,119,119,112,119,119,119,112,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_33_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,119,119,119,7,119,119,119,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,0,119,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_34_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,119,119,119,7,119,119,119,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,0,112,119,0,0,112,119,0,0,112,119,119,112,112,119,119,119,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,112,119,119,119,112,119,119,119,112,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_35_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,119,119,119,7,119,119,119,7,119,119,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,112,0,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,7,119,112,0,119,119,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,0,119,112,119,119,119,112,119,119,119,112,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_36_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,119,7,112,7,119,7,112,7,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,112,7,0,7,112,7,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,7,119,119,112,119,119,119,112,119,119,112,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,0,0,112,119,119,119,112,119,119,119,0,7,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_37_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,119,7,112,7,119,7,112,7,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,112,7,0,7,112,7,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,112,119,119,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_38_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,119,7,112,7,119,7,112,7,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,112,7,0,7,112,7,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,0,112,119,0,0,112,119,0,0,112,119,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_db_39_data[3][96]={
{0,0,0,0,0,0,0,0,0,0,119,119,0,7,119,119,0,7,119,119,0,7,112,7,0,7,112,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,7,119,7,112,7,119,7,112,7,119,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,7,112,7,0,7,112,7,0,7,119,119,0,7,119,119,0,0,119,119,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,7,119,112,112,119,119,119,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,7,119,112,112,119,119,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,0,119,112,119,119,119,112,119,119,119,0,7,119,112,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,7,112,0,0,7,112,0,0,7,112,0,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,0,119,119,112,0,0,0,0,7,119,119,0,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,112,7,112,7,112,7,112,7,112,7,119,119,112,7,119,119,0,0,0,0,0,0,0,0,0}
};




const unsigned char font_dai_red_suji_01_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0}    
};
const unsigned char font_dai_red_suji_02_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_03_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_04_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_05_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_06_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_07_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_08_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_09_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0}
};
const unsigned char font_dai_red_suji_10_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0}
};


const unsigned char font_dai_lb_suji_01_data[4][128]={
{0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_02_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_03_data[4][128]={
{0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_04_data[4][128]={
{0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_05_data[4][128]={
{0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_06_data[4][128]={
{0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_07_data[4][128]={
{0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_08_data[4][128]={
{0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_09_data[4][128]={
{0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_suji_10_data[4][128]={
{0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};



const unsigned char font_dai_w_suji_01_data[4][128]={
{0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,112,0,119,119,0,0,119,112,0,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_02_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_03_data[4][128]={
{0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,112,0,119,119,0,0,119,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_04_data[4][128]={
{0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,112,0,119,119,0,0,119,112,0,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_05_data[4][128]={
{0,0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_06_data[4][128]={
{0,0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,112,0,119,119,0,0,119,112,0,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_07_data[4][128]={
{0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,112,0,119,119,0,0,119,112,0,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_08_data[4][128]={
{0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_09_data[4][128]={
{0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,112,0,119,119,0,0,119,112,0,0,0,0,0,0}
};
const unsigned char font_dai_w_suji_10_data[4][128]={
{0,0,0,0,0,0,7,119,0,0,119,119,0,7,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,7,119,119,0,0,119,119,0,0,7,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0},
{0,0,0,0,119,112,0,0,119,119,0,0,119,119,112,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,119,0,119,119,112,0,119,119,0,0,119,112,0,0,0,0,0,0}
};


const unsigned char font_dai_red_k_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,17,0,0,1,17,0,0,17,17,0,1,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,17,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,17,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,1,17,17,17,17,17,17,17,17,17,17,16,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,17,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,17,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,16,17,17,17,17,1,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,17,0,0,0,0},
{0,0,0,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,17,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,17,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_h_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_z_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,17,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,1,17,17,17,17,17,17,17,17,17,17,16,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,17,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,17,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,1,17,17,17,17,17,17,17,17,17,17,16,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,17,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_f_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_dai_red_r_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,17,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,16,17,17,17,17,1,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,17,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_e_data[4][128]={
{0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,0,0,0,0}
};
const unsigned char font_dai_red_q_data[4][128]={
{0,0,0,0,0,0,1,17,0,0,17,17,0,1,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,1,17,17,0,0,17,17,0,0,1,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,17,16,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,17,17,17,0,1,17,17,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0},
{0,0,0,0,17,16,0,0,17,17,0,0,17,17,16,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,17,0,17,17,16,0,17,17,0,0,17,16,0,0,0,0,0,0}
};
const unsigned char font_dai_red_dot_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,1,17,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,17,16,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};





const unsigned char font_dai_lb_d_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,102,0,0,102,102,0,6,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,6,102,102,0,0,102,102,0,0,6,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_b_data[4][128]={
{0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,96,0,0,102,102,0,0,102,102,96,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,96,0,102,102,0,0,102,96,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_l_data[4][128]={
{0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0}
};
const unsigned char font_dai_lb_e_data[4][128]={
{0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0},
{0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0}
};
const unsigned char font_dai_lb_v_data[4][128]={
{0,0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,0,0,0,0},
{0,0,0,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,102,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_dot_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_dai_lb_bar_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,102,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

const unsigned char font_dai_or_o_data[4][128]={
{0,0,0,0,0,0,11,187,0,0,187,187,0,11,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,11,187,187,0,0,187,187,0,0,11,187,0,0,0,0},
{0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0},
{0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0},
{0,0,0,0,187,176,0,0,187,187,0,0,187,187,176,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,176,0,187,187,0,0,187,176,0,0,0,0,0,0}
};
const unsigned char font_dai_or_n_data[4][128]={
{0,0,0,0,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,187,0,0,0,187,0,0,0,187,187,0,0,187,187,0,0,187,187,187,0,187,187,187,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,187,187,187,0,187,187,187,0,0,187,187,0,0,187,187,0,0,0,187,0,0,0,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,0,0,0,187,0,0,0,187,187,0,0,187,187,0,0,187,187,187,0,187,187,187,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,187,187,187,0,187,187,187,0,0,187,187,0,0,187,187,0,0,0,187,0,0,0,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,0,0,0,0}
};
const unsigned char font_dai_or_f_data[4][128]={
{0,0,0,0,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,0,0,0},
{0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,187,187,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};



const unsigned char font_dai_g_r_data[4][128]={
{0,0,0,0,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,10,170,170,0,0,170,170,0,0,10,170,0,0,0,170,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,160,0,0,170,170,0,0,170,170,160,0,170,170,170,0,170,170,170,160,170,170,170,170,10,170,170,170,0,170,170,170,0,10,170,170,0,0,170,170,0,0,10,170,0,0,0,170,0,0,0,0},
{0,0,0,0,170,160,0,0,170,170,0,0,170,170,160,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,160,0,170,170,0,0,170,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,170,0,0,0,170,160,0,0,170,170,0,0,170,170,160,0,170,170,170,0,0,0,0,0}
};
const unsigned char font_dai_g_a_data[4][128]={
{0,0,0,0,0,0,10,170,0,0,170,170,0,10,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,170,160,0,0,170,170,0,0,170,170,160,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0,0}
};
const unsigned char font_dai_g_n_data[4][128]={
{0,0,0,0,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,170,0,0,0,170,170,0,0,170,170,0,0,170,170,170,0,170,170,170,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,170,170,170,0,170,170,170,0,0,170,170,0,0,170,170,0,0,0,170,0,0,0,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,170,0,0,0,170,170,0,0,170,170,0,0,170,170,170,0,170,170,170,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,170,170,170,0,170,170,170,0,0,170,170,0,0,170,170,0,0,0,170,0,0,0,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0,0}
};
const unsigned char font_dai_g_g_data[4][128]={
{0,0,0,0,0,0,10,170,0,0,170,170,0,10,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,10,170,170,0,0,170,170,0,0,10,170,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0},
{0,0,0,0,170,160,0,0,170,170,0,0,170,170,160,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,170,160,0,0,170,170,0,0,170,170,160,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,160,0,170,170,0,0,170,160,0,0,0,0,0,0}
};
const unsigned char font_dai_g_e_data[4][128]={
{0,0,0,0,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0},
{0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,0,0,0,0},
{0,0,0,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,170,170,170,0,0,0,0,0}
};

const unsigned char font_dai_w_dot_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_dai_w_bar_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};
const unsigned char font_dai_w_plus_data[4][128]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,7,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,119,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};




const unsigned char font_w_suji_01_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_02_data[2][64]={
{0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,},
{119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_03_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_04_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_05_data[2][64]={
{119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_06_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_07_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_08_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_09_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_suji_10_data[2][64]={
{119,119,119,119,119,119,119,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,119,119,119,119,119,119,119,119,0,0,0,0,0,0,0,0,},
{119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,0,119,119,0,119,119,119,0,119,119,119,0,0,0,0,0,0,0,0,0,},
};


const unsigned char font_w_dot_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_bar_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,119,119,0,7,119,119,0,7,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,0,0,119,119,0,0,119,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_w_plus_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,119,0,0,0,119,0,7,119,119,0,7,119,119,0,7,119,119,0,0,0,119,0,0,0,119,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,112,0,0,0,112,0,0,0,119,119,0,0,119,119,0,0,119,119,0,0,112,0,0,0,112,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};


const unsigned char font_r_f_data[2][64]={
{17,17,17,17,17,17,17,17,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,17,17,17,17,17,17,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,0,0,0,0,0,0,0,0,},
{17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,0,0,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_r_co_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,1,17,0,0,1,17,0,0,1,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,0,0,1,17,0,0,1,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,16,0,0,0,16,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,16,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_r_h_data[2][64]={
{17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,17,17,17,17,17,17,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,0,0,0,0,0,0,0,0,},
{0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,17,17,17,0,17,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,17,17,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_r_z_data[2][64]={
{17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,0,0,17,17,0,17,17,0,0,17,17,0,17,17,0,0,17,17,0,0,17,17,17,17,17,17,17,17,0,0,0,0,0,0,0,0,},
{17,17,17,0,17,17,17,0,0,17,17,0,0,17,17,0,17,17,0,0,17,17,0,0,17,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,17,17,0,17,17,17,0,0,0,0,0,0,0,0,0,},
};



const unsigned char font_lb_l_data[2][64]={
{102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_lb_co_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,102,0,0,6,102,0,0,6,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,96,0,0,0,96,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,96,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_lb_d_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,102,6,102,102,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,6,102,102,102,0,102,102,102,0,0,0,0,0,0,0,0,},
{0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,102,102,102,0,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_lb_b_data[2][64]={
{102,102,102,102,102,102,102,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,102,102,102,102,102,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,},
{102,102,0,0,102,102,96,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,102,102,102,0,102,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,0,102,102,0,102,102,96,0,102,102,0,0,0,0,0,0,0,0,0,0,},
};


const unsigned char font_m_right_data[2][64]={
{0,0,0,0,0,0,0,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,85,85,0,0,85,85,85,0,85,85,85,0,85,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_up_data[2][64]={
{0,0,0,85,0,0,0,85,0,0,5,85,0,0,5,85,0,0,85,85,0,0,85,85,0,5,85,85,0,5,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,80,0,0,0,80,0,0,0,85,0,0,0,85,0,0,0,85,80,0,0,85,80,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_s_data[2][64]={
{0,85,85,85,5,85,85,85,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,85,85,0,0,85,85,0,0,5,85,85,85,0,85,85,85,0,0,0,0,0,0,0,0,},
{85,85,0,0,85,85,80,0,0,85,85,0,0,85,85,0,0,0,0,0,0,0,0,0,85,85,85,0,85,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,85,85,80,0,85,85,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_w_data[2][64]={
{85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,5,85,80,0,0,85,0,0,0,0,0,0,0,0,0,0,},
{0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,5,85,80,0,0,85,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_bar_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,85,0,5,85,85,0,5,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,0,0,85,85,0,0,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_u_data[2][64]={
{85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,5,85,85,85,0,85,85,85,0,0,0,0,0,0,0,0,},
{0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,85,85,80,0,85,85,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_p_data[2][64]={
{85,85,85,85,85,85,85,85,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,85,85,85,85,85,85,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,0,0,0,0,0,0,0,0,},
{85,85,0,0,85,85,80,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,85,85,80,0,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_d_data[2][64]={
{85,85,85,85,85,85,85,85,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,},
{85,85,0,0,85,85,80,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,85,85,80,0,85,85,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_m_n_data[2][64]={
{85,85,0,0,85,85,80,0,85,85,85,0,85,85,85,0,85,85,85,80,85,85,85,85,85,85,85,85,85,85,5,85,85,85,0,85,85,85,0,5,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,0,0,0,0,0,0,0,0,},
{0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,0,85,85,0,80,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,85,85,85,0,5,85,85,0,0,85,85,0,0,0,0,0,0,0,0,0,},
};




const unsigned char font_g_s_data[2][64]={
{34,34,34,34,34,34,34,34,34,34,0,0,34,34,0,0,34,34,0,0,34,34,0,0,34,34,34,34,34,34,34,34,0,0,0,0,0,0,0,0,34,34,0,0,34,34,0,0,34,34,34,34,34,34,34,34,0,0,0,0,0,0,0,0,},
{34,34,34,0,34,34,34,0,0,34,34,0,0,34,34,0,0,0,0,0,0,0,0,0,34,34,34,0,34,34,34,0,0,34,34,0,0,34,34,0,0,34,34,0,0,34,34,0,34,34,34,0,34,34,34,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_g_bar_data[2][64]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,34,34,0,2,34,34,0,2,34,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,34,0,0,34,34,0,0,34,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};


const unsigned char font_y_o_data[2][64]={
{0,68,68,68,4,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,4,68,68,68,0,68,68,68,0,0,0,0,0,0,0,0,},
{68,68,0,0,68,68,64,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_n_data[2][64]={
{68,68,0,0,68,68,64,0,68,68,68,0,68,68,68,0,68,68,68,64,68,68,68,68,68,68,68,68,68,68,4,68,68,68,0,68,68,68,0,4,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,0,},
{0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,64,68,68,0,68,68,68,0,68,68,68,0,68,68,68,0,68,68,68,0,68,68,68,0,4,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_f_data[2][64]={
{68,68,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,0,},
{68,68,68,0,68,68,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_r_data[2][64]={
{68,68,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,0,},
{68,68,0,0,68,68,64,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,68,68,64,0,68,68,0,0,68,68,0,0,68,68,0,0,4,68,64,0,4,68,64,0,0,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_c_data[2][64]={
{0,68,68,68,4,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,4,68,68,68,0,68,68,68,0,0,0,0,0,0,0,0,},
{68,68,68,0,68,68,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,68,68,0,68,68,68,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_u_data[2][64]={
{68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,4,68,68,68,0,68,68,68,0,0,0,0,0,0,0,0,},
{0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_p_data[2][64]={
{68,68,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,0,0,0,0,0,0,0,0,},
{68,68,0,0,68,68,64,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_d_data[2][64]={
{68,68,68,68,68,68,68,68,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,68,68,68,68,68,68,0,0,0,0,0,0,0,0,},
{68,68,0,0,68,68,64,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,0,68,68,0,68,68,64,0,68,68,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_y_t_data[2][64]={
{0,68,68,68,0,68,68,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,0,0,0,0,0,},
{68,68,68,0,68,68,68,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,},
};

const unsigned char font_b_d_data[2][64]={
{221,221,221,221,221,221,221,221,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,221,221,221,221,221,221,0,0,0,0,0,0,0,0,},
{221,221,0,0,221,221,208,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,221,221,208,0,221,221,0,0,0,0,0,0,0,0,0,0,},
};
const unsigned char font_b_o_data[2][64]={
{0,221,221,221,13,221,221,221,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,13,221,221,221,0,221,221,221,0,0,0,0,0,0,0,0,},
{221,221,0,0,221,221,208,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,0,221,221,0,221,221,208,0,221,221,0,0,0,0,0,0,0,0,0,0,},
};


const unsigned char s_font_hz_data[2][32]={
{34,0,2,32,34,0,2,32,34,0,2,32,34,34,34,32,34,0,2,32,34,0,2,32,34,0,2,32,0,0,0,0,},
{34,34,34,32,0,0,2,32,0,0,34,0,0,34,32,0,2,32,0,0,34,0,0,0,34,34,34,32,0,0,0,0,},
};
const unsigned char s_font_mc_data[2][32]={
{102,0,6,96,102,96,102,96,102,102,102,96,102,6,6,96,102,0,6,96,102,0,6,96,102,0,6,96,0,0,0,0,},
{6,102,102,0,102,0,6,96,102,0,0,0,102,0,0,0,102,0,0,0,102,0,6,96,6,102,102,0,0,0,0,0,},
};
const unsigned char s_font_up_data[2][32]={
{68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,68,0,4,64,4,68,68,0,0,0,0,0,},
{68,68,68,0,68,0,4,64,68,0,4,64,68,68,68,0,68,0,0,0,68,0,0,0,68,0,0,0,0,0,0,0,},
};
const unsigned char s_font_dn_data[2][32]={
{187,187,187,0,187,0,11,176,187,0,11,176,187,0,11,176,187,0,11,176,187,0,11,176,187,187,187,0,0,0,0,0,},
{187,0,11,176,187,176,11,176,187,187,11,176,187,187,187,176,187,11,187,176,187,0,187,176,187,0,11,176,0,0,0,0,},
};
const unsigned char s_font_db_data[2][32]={
{34,34,34,0,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,0,2,32,34,34,34,0,0,0,0,0,},
{34,34,34,0,34,0,2,32,34,0,2,32,34,34,34,32,34,0,2,32,34,0,2,32,34,34,34,0,0,0,0,0,},
};
const unsigned char s_font_st_data[2][32]={
{4,68,68,0,68,0,4,64,68,0,0,0,68,68,68,64,0,0,4,64,68,0,4,64,4,68,68,0,0,0,0,0,},
{4,68,68,64,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,4,64,0,0,0,0,0,},
};
const unsigned char s_font_do_data[2][32]={
{204,204,204,0,204,0,12,192,204,0,12,192,204,0,12,192,204,0,12,192,204,0,12,192,204,204,204,0,0,0,0,0,},
{12,204,204,0,204,0,12,192,204,0,12,192,204,0,12,192,204,0,12,192,204,0,12,192,12,204,204,0,0,0,0,0,},
};



///////////////////////////////////////////////
void    vram_set_level(unsigned int xx,unsigned int yy,unsigned long data);
void    vram_set_s_level(unsigned int xx,unsigned int yy,unsigned long data);
///////////////////////////////////////////////

// delay
#define CCLK			(9600000L)
#define PBCLK		(CCLK / 2)
#define SAMPLE_RATE	5000
#define CCLK_US		(PBCLK / 100 / 1000)
#define CCLK_MS		(PBCLK / 100)

void delay_us(unsigned int  d) 
{
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();     
	delayCount = d * CCLK_US; 
	while((_CP0_GET_COUNT() - startTime) < delayCount);  
 }

void delay_ms(unsigned int d)
{   
	unsigned int delayCount, startTime;       

	startTime = _CP0_GET_COUNT();   
	delayCount = d * CCLK_MS;   
	while((_CP0_GET_COUNT() - startTime) < delayCount);   
}

void    send_cmd(unsigned char cmd)
{
    GPIO_PinWrite(LCD_DC,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)cmd);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data(unsigned char data)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_2(unsigned char data1,unsigned char data2)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}

void    send_data_4(unsigned char data1,unsigned char data2,unsigned char data3,unsigned char data4)
{
    GPIO_PinWrite(LCD_DC,1);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data1);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data2);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data3);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
    GPIO_PortWrite(GPIO_PORT_D,0xff,(unsigned int)data4);
    GPIO_PinWrite(LCD_WR,1);
    GPIO_PinWrite(LCD_WR,0);
}


void    set_up(void)
{
    GPIO_PinWrite(LCD_RST,1);
    delay_us(10);
    GPIO_PinWrite(LCD_WR,0);
    delay_us(10);
    GPIO_PinWrite(LCD_RD,1);
    delay_ms(10);
    GPIO_PinWrite(LCD_CS,0);
    delay_us(10);

    send_cmd(0xc8);
    send_data(0xff);
    send_data(0x93);
    send_data(0x42);
    
    send_cmd(0x2a);
    send_data_4(0x00,0x00,0x01,0x3f);
    
    send_cmd(0x2b);
    send_data_4(0xff,0xfe,0x00,0xf1);        //send_data_4(0x00,0x00,0x00,0x5f);

    send_cmd(0x36);
    if(lcdmode==1){
        send_data(0x28);          
    }
    else{
        send_data(0x48);
    }
    
    send_cmd(0xc0);
    send_data(0x0e);
    send_data(0x0e);

    send_cmd(0xc1);
    send_data(0x10);

    send_cmd(0xc5);
    send_data(0xfa);

    send_cmd(0x3a);
    send_data(0x55);

    send_cmd(0xb1);
    send_data(0x00);
    send_data(0x18);

    send_cmd(0xe0);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x21);
    send_data(0x02);
    send_data(0x11);
    send_data(0x07);
    send_data(0x3d);
    send_data(0x79);
    send_data(0x4b);
    send_data(0x07);
    send_data(0x0f);
    send_data(0x0c);
    send_data(0x1b);
    send_data(0x1f);
    send_data(0x0f);

    send_cmd(0xe1);
    send_data(0x00);
    send_data(0x1c);
    send_data(0x20);
    send_data(0x04);
    send_data(0x0f);
    send_data(0x04);
    send_data(0x33);
    send_data(0x45);
    send_data(0x42);
    send_data(0x04);
    send_data(0x0c);
    send_data(0x0a);
    send_data(0x22);
    send_data(0x29);
    send_data(0x0f);

    send_cmd(0x11);
    delay_ms(130);

    send_cmd(0x29);
    delay_ms(100);
}


void    disp_main2(void)
{
    unsigned int    i,j;
    unsigned char   data1,data2;

            GPIO_PinWrite(TEST,1);
            send_cmd(0x2a);
            send_data_4(0x00,0x00,0x01,0x3f);
            send_cmd(0x2b);
            send_data_4(0x00,0x00,0x00,0xef);    //send_data_4(0x00,0x00,0x00,0x5f);    
            send_cmd(0x2c);
    
            GPIO_PinWrite(LCD_DC,1);
            for(j=0;j<240;j++){
                for(i=0;i<160;i++){
                    data1=vram1[i+j*160] >> 4;      // 240
                    data2=vram1[i+j*160] & 0x0f;    // 240
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data1];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data1];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data1[data2];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB + (GPIO_PORT_D * 0x40)) = color_data2[data2];
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x01) << (LCD_WR & 0xF)));
                    *(volatile uint32_t *)(&LATB) = (*(volatile uint32_t *)(&LATB) & (~((uint32_t)(0x1) << (LCD_WR & 0xF)))) | (((uint32_t)(0x1) << (LCD_WR & 0xF)) & ((uint32_t)(0x00) << (LCD_WR & 0xF)));
                }
            } 

            GPIO_PinWrite(TEST,0);                
}
void    vram_clear(void)
{
    unsigned int    i,j;
    
    for(j=0;j<240;j++){
        for(i=0;i<160;i++){
            vram1[i+j*160]=0;
        }
    }
}

////////////////////////////////////////////////////
void    vram_set_font_clear(unsigned int xx,unsigned int yy)
{
        unsigned char   data;
    unsigned long    i,j,k;

    for(k=0;k<3;k++){
        for(j=0;j<24;j++){
            for(i=0;i<4;i++){
                data=0;
                vram1[k*4+xx+i+(yy*2+j)*160]=data;
            }
        }
    }     
}

void    vram_set_hz_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 13:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_14_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 14:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_15_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 15:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_16_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 16:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_17_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 17:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_18_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 18:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_19_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 19:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_20_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 20:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_21_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 21:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_hz_22_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
            
    }        
}


void    vram_set_db_font(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 10:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_11_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 11:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_12_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 12:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_13_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 13:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_14_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 14:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_15_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 15:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_16_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 16:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_17_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 17:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_18_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 18:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_19_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 19:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_20_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 20:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_21_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 21:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_22_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 22:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_23_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 23:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_24_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 24:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_25_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 25:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_26_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 26:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_27_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 27:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_28_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 28:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_29_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 29:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_30_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 30:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_31_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 31:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_32_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 32:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_33_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 33:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_34_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 34:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_35_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 35:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_36_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 36:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_37_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 37:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_38_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 38:
            for(k=0;k<3;k++){
                for(j=0;j<24;j++){
                    for(i=0;i<4;i++){
                        data=font_db_39_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
            
    }        
}


void    vram_set_dai_clear(unsigned int xx,unsigned int yy)
{
        unsigned char   data;
    unsigned long    i,j,k;

    for(k=0;k<4;k++){
        for(j=0;j<32;j++){
            for(i=0;i<4;i++){
                data=0;
                vram1[k*4+xx+i+(yy*2+j)*160]=data;
            }
        }
    }     
}
void    vram_set_s_clear(unsigned int xx,unsigned int yy)
{
        unsigned char   data;
    unsigned long    i,j,k;

    for(k=0;k<2;k++){
        for(j=0;j<16;j++){
            for(i=0;i<4;i++){
                data=0;
                vram1[k*4+xx+i+(yy*2+j)*160]=data;
            }
        }
    }     
}
void    vram_set_dai_red_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_suji_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }        
}


void    vram_set_dai_lb_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_suji_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }        
}


void    vram_set_dai_w_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_suji_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }        
}



void    vram_set_dai_red_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_k_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_h_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_z_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_f_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_r_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_e_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_q_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_red_dot_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;            
    }
}



void    vram_set_dai_lb_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_d_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_b_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_l_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_e_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_v_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_dot_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_lb_bar_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;            
    }
}


void    vram_set_dai_or_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_or_o_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_or_n_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_or_f_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }
}


void    vram_set_dai_g_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_g_r_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_g_a_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_g_n_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_g_g_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_g_e_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;            
    }
}


void    vram_set_dai_w_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_dot_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_bar_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<4;k++){
                for(j=0;j<32;j++){
                    for(i=0;i<4;i++){
                        data=font_dai_w_plus_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }
}


void    vram_set_w_suji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_01_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_02_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_03_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_04_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_05_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_06_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_07_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 7:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_08_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 8:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_09_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 9:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_suji_10_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }        
}

void    vram_set_w_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_dot_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_bar_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_w_plus_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }        
}


void    vram_set_r_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_r_f_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_r_co_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_r_h_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_r_z_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }
}


void    vram_set_lb_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_lb_l_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_lb_co_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_lb_d_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_lb_b_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }
}


void    vram_set_m_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_right_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_up_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_s_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_w_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;  
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_bar_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;  
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_u_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;  
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_p_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;  
        case 7:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_d_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;  
        case 8:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_m_n_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;              
    }
}




void    vram_set_g_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_g_s_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_g_bar_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }
}


void    vram_set_y_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_o_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_n_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_f_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_r_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_c_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_u_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_p_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;  
        case 7:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_d_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;  
        case 8:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_y_t_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;              
    }
}

void    vram_set_b_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_b_d_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<16;j++){
                    for(i=0;i<4;i++){
                        data=font_b_o_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
    }
}


void    vram_set_small_moji(unsigned int xx,unsigned int yy,unsigned char no)
{
    unsigned char   data;
    unsigned long    i,j,k;

    switch(no){
        case 0:
            for(k=0;k<2;k++){
                for(j=0;j<8;j++){
                    for(i=0;i<4;i++){
                        data=s_font_hz_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 1:
            for(k=0;k<2;k++){
                for(j=0;j<8;j++){
                    for(i=0;i<4;i++){
                        data=s_font_mc_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 2:
            for(k=0;k<2;k++){
                for(j=0;j<8;j++){
                    for(i=0;i<4;i++){
                        data=s_font_up_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 3:
            for(k=0;k<2;k++){
                for(j=0;j<8;j++){
                    for(i=0;i<4;i++){
                        data=s_font_dn_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 4:
            for(k=0;k<2;k++){
                for(j=0;j<8;j++){
                    for(i=0;i<4;i++){
                        data=s_font_db_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 5:
            for(k=0;k<2;k++){
                for(j=0;j<8;j++){
                    for(i=0;i<4;i++){
                        data=s_font_st_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;
        case 6:
            for(k=0;k<2;k++){
                for(j=0;j<8;j++){
                    for(i=0;i<4;i++){
                        data=s_font_do_data[k][j*4+i];
                        vram1[k*4+xx+i+(yy*2+j)*160]=data;
                    }
                }
            }            
            break;            
    }
}

////////////////////////////////////////////
void    vram_pset(unsigned int x0,unsigned int y0,unsigned char col)
{
    unsigned char data;
    
    data=vram1[x0/2+y0*160];
    if((x0 & 0x01)==0x00){
        data=data & 0x0f;
        data=data | (col <<4);
    }
    else{
        data=data & 0xf0;
        data= data | col;
    }
    vram1[x0/2+y0*160]=data;
    
};
void    vram_line_a(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2,unsigned char col)
{
    int w,h,dx,dy,wy,hx;
    
    w=x2-x1;
    h=y2-y1;
    dx=0;
    dy=0;
    wy=0;
    hx=0;
    
    if(h>=0){
        if(w>=h){
            for(dx=0;dx<=w;dx++){
            if(((y1+dy)>=32)&&((y1+dy)<=216)){
                vram_pset(x1+dx,y1+dy,col);
            }
                hx=hx+h;
                if(wy<hx){
                    wy=wy+w;
                    dy=dy+1;
                }
            }
        }
        else{
            for(dy=0;dy<=h;dy++){
                if(((y1+dy)>=32)&&((y1+dy)<=216)){
                    vram_pset(x1+dx,y1+dy,col);
                }
                wy=wy+w;
                if(hx<wy){
                    hx=hx+h;
                    dx=dx+1;
                }
            }
        }
    }
    else{
        h=-h;
        if(w>=h){
            for(dx=0;dx<=w;dx++){
                if(((y1+dy)>=32)&&((y1+dy)<=216)){
                    vram_pset(x1+dx,y1+dy,col);
                }
                hx=hx+h;
                if(wy<hx){
                    wy=wy+w;
                    dy=dy-1;
                }
            }
        }
        else{
            for(dy=0;dy<=h;dy++){
                if(((y1-dy)>=32)&&((y1-dy)<=216)){
                    vram_pset(x1+dx,y1-dy,col);
                }
                wy=wy+w;
                if(hx<wy){
                    hx=hx+h;
                    dx=dx+1;
                }
            }
        }        
    }

}
void    vram_line(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2,unsigned char col)
{
    int w,h,dx,dy,wy,hx;
    
    w=x2-x1;
    h=y2-y1;
    dx=0;
    dy=0;
    wy=0;
    hx=0;
    
    if(h>=0){
        if(w>=h){
            for(dx=0;dx<=w;dx++){
                vram_pset(x1+dx,y1+dy,col);
                hx=hx+h;
                if(wy<hx){
                    wy=wy+w;
                    dy=dy+1;
                }
            }
        }
        else{
            for(dy=0;dy<=h;dy++){
                vram_pset(x1+dx,y1+dy,col);
                wy=wy+w;
                if(hx<wy){
                    hx=hx+h;
                    dx=dx+1;
                }
            }
        }
    }
    else{
        h=-h;
        if(w>=h){
            for(dx=0;dx<=w;dx++){
                vram_pset(x1+dx,y1+dy,col);
                hx=hx+h;
                if(wy<hx){
                    wy=wy+w;
                    dy=dy-1;
                }
            }
        }
        else{
            for(dy=0;dy<=h;dy++){
                vram_pset(x1+dx,y1-dy,col);
                wy=wy+w;
                if(hx<wy){
                    hx=hx+h;
                    dx=dx+1;
                }
            }
        }        
    }

}
void    vram_set_h_waku_main_dot(void)
{
    unsigned int     i;

    for(i=24;i<312;i=i+2){
        vram_pset(i,32+12,graph_color[graph_color_set][2]);
        vram_pset(i,56+12,graph_color[graph_color_set][2]);
        vram_pset(i,80+12,graph_color[graph_color_set][2]);
        vram_pset(i,104+12,graph_color[graph_color_set][2]);
        vram_pset(i,128+12,graph_color[graph_color_set][2]);
        vram_pset(i,152+12,graph_color[graph_color_set][2]);
        vram_pset(i,176+12,graph_color[graph_color_set][2]);
        vram_pset(i,200+12,graph_color[graph_color_set][2]);
    }        
}
void    vram_set_h_waku_mian_line(void)
{
    unsigned int     i;

    for(i=24;i<312;i++){
        vram_pset(i,32,graph_color[graph_color_set][3]);
        vram_pset(i,56,graph_color[graph_color_set][3]);
        vram_pset(i,80,graph_color[graph_color_set][3]);
        vram_pset(i,104,graph_color[graph_color_set][3]);
        vram_pset(i,128,graph_color[graph_color_set][3]);
        vram_pset(i,152,graph_color[graph_color_set][3]);
        vram_pset(i,176,graph_color[graph_color_set][3]);
        vram_pset(i,200,graph_color[graph_color_set][3]);
    }                
}
void    vram_set_waku_main_1(void)
{
    unsigned int     i;
    
    switch(hz_mode){
        case 0:
            for(i=24;i<216;i=i+2){
                vram_pset(60,i,graph_color[graph_color_set][2]);
                vram_pset(115,i,graph_color[graph_color_set][2]);
                vram_pset(131,i,graph_color[graph_color_set][2]);
                vram_pset(142,i,graph_color[graph_color_set][2]);
                vram_pset(151,i,graph_color[graph_color_set][2]);
                vram_pset(205,i,graph_color[graph_color_set][2]);
                vram_pset(221,i,graph_color[graph_color_set][2]);
                vram_pset(233,i,graph_color[graph_color_set][2]);
                vram_pset(241,i,graph_color[graph_color_set][2]);
                vram_pset(296,i,graph_color[graph_color_set][2]);
            }
            vram_set_h_waku_main_dot();
    
            for(i=24;i<216;i++){
                vram_pset(24,i,graph_color[graph_color_set][3]);
                vram_pset(88,i,graph_color[graph_color_set][3]);
                vram_pset(178,i,graph_color[graph_color_set][3]);
                vram_pset(269,i,graph_color[graph_color_set][3]);
                vram_pset(312,i,graph_color[graph_color_set][3]);
            }
            vram_set_h_waku_mian_line();
            break;
        case 1:
            for(i=24;i<216;i=i+2){
                vram_pset(52,i,graph_color[graph_color_set][2]);
                vram_pset(72,i,graph_color[graph_color_set][2]);                                
                vram_pset(88,i,graph_color[graph_color_set][2]);
                vram_pset(184,i,graph_color[graph_color_set][2]);
                vram_pset(212,i,graph_color[graph_color_set][2]);
                vram_pset(232,i,graph_color[graph_color_set][2]);                
                vram_pset(248,i,graph_color[graph_color_set][2]);
            }
            vram_set_h_waku_main_dot();
    
            for(i=24;i<216;i++){
                vram_pset(24,i,graph_color[graph_color_set][3]);
                vram_pset(136,i,graph_color[graph_color_set][3]);
                vram_pset(296,i,graph_color[graph_color_set][3]);
            }
            vram_set_h_waku_mian_line();
            break;
        case 2:
            for(i=24;i<216;i=i+2){
                vram_pset(107,i,graph_color[graph_color_set][2]);
                vram_pset(154,i,graph_color[graph_color_set][2]);                                
                vram_pset(188,i,graph_color[graph_color_set][2]);
                vram_pset(214,i,graph_color[graph_color_set][2]);
                vram_pset(236,i,graph_color[graph_color_set][2]);                
                vram_pset(254,i,graph_color[graph_color_set][2]);
                vram_pset(270,i,graph_color[graph_color_set][2]); 
                vram_pset(284,i,graph_color[graph_color_set][2]);                
            }
            vram_set_h_waku_main_dot();
    
            for(i=24;i<216;i++){
                vram_pset(25,i,graph_color[graph_color_set][3]);
                vram_pset(296,i,graph_color[graph_color_set][3]);
            }
            vram_set_h_waku_mian_line();            
            break;
        case 3:
            for(i=24;i<216;i=i+2){
                vram_pset(106,i,graph_color[graph_color_set][2]);
                vram_pset(154,i,graph_color[graph_color_set][2]);                                
                vram_pset(188,i,graph_color[graph_color_set][2]);
                vram_pset(214,i,graph_color[graph_color_set][2]);
                vram_pset(236,i,graph_color[graph_color_set][2]);                
                vram_pset(254,i,graph_color[graph_color_set][2]);
                vram_pset(270,i,graph_color[graph_color_set][2]); 
                vram_pset(284,i,graph_color[graph_color_set][2]);                
            }
            vram_set_h_waku_main_dot();
    
            for(i=24;i<216;i++){
                vram_pset(24,i,graph_color[graph_color_set][3]);
                vram_pset(296,i,graph_color[graph_color_set][3]);
            }
            vram_set_h_waku_mian_line();             
            break;
        
    }

}





//////////////////////////////////////////
void    vram_set_hz_font_main(void)
{
    switch(hz_mode){
        case 0:
            vram_set_hz_font(12-4,27*4,0);
            vram_set_hz_font(30-4,27*4,1);
            vram_set_hz_font(44-4,27*4,2);
            vram_set_hz_font(75-4,27*4,3);
            vram_set_hz_font(89-4,27*4,4);
            vram_set_hz_font(121-4,27*4,5);
            vram_set_hz_font(134-4,27*4,6);
            vram_set_hz_font(148-4,27*4,7);
            break;
        case 1:
            vram_set_hz_font(12-4,27*4,0);
            vram_set_hz_font(44-4,27*4,1);
            vram_set_hz_font(68-4,27*4,2);
            vram_set_hz_font(124-4,27*4,3);
            vram_set_hz_font(148-4,27*4,4);            
            break;
        case 2:
            vram_set_hz_font(13-4,27*4,2);
            vram_set_hz_font(54-4,27*4,8);
            vram_set_hz_font(77-4,27*4,9);
            vram_set_hz_font(94-4,27*4,10);
            vram_set_hz_font(107-4,27*4,3);
            vram_set_hz_font(118-4,27*4,11);
            //vram_set_hz_font(127-4,27*4,12);
            vram_set_hz_font(135-4,27*4,13);
            //vram_set_hz_font(142-4,27*4,14);
            vram_set_hz_font(148-4,27*4,4);            
            break;
        case 3:
            vram_set_hz_font(12-4,27*4,4);
            vram_set_hz_font(53-4,27*4,15);
            vram_set_hz_font(77-4,27*4,16);
            vram_set_hz_font(94-4,27*4,17);
            vram_set_hz_font(107-4,27*4,5);
            vram_set_hz_font(118-4,27*4,18);
            //vram_set_hz_font(127-4,27*4,19);
            vram_set_hz_font(135-4,27*4,20);
            //vram_set_hz_font(142-4,27*4,21);
            vram_set_hz_font(148-4,27*4,6);             
            break;
    }

    
}
void    vram_set_db_font_main_1(void){
    unsigned int    i;
    
    switch(db_mode){
        case 0:
            for(i=0;i<8;i++){
                vram_set_db_font(0,3*4*i+10,db_retu_1[i]);
            }
            break;
        case 1:
            for(i=0;i<8;i++){
                vram_set_db_font(0,3*4*i+10,db_retu_2[i+db_pointa1]);
            }
            break;
        case 2:
            for(i=0;i<8;i++){
                vram_set_db_font(0,3*4*i+10,db_retu_3[i+db_pointa2]);
            }
            break;
        case 3:
            for(i=0;i<8;i++){
                vram_set_db_font(0,3*4*i+10,db_retu_4[i+db_pointa3]);
            }
    }
}

//////////////////////////////////////////
void    vram_set_freq_dai_moji(unsigned int xx,unsigned int yy)
{
    vram_set_dai_red_moji(xx,yy,3);
    vram_set_dai_red_moji(xx+16,yy,4);
    vram_set_dai_red_moji(xx+32,yy,5);
    vram_set_dai_red_moji(xx+48,yy,6);
    vram_set_dai_red_moji(xx+64,yy,7);
}
void    vram_set_hz_dai_moji(unsigned int xx,unsigned int yy)
{
    vram_set_dai_red_moji(xx,yy,1);
    vram_set_dai_red_moji(xx+16,yy,2);
}
void    vram_set_level_dai_moji(unsigned int xx,unsigned int yy)
{
    vram_set_dai_lb_moji(xx,yy,2);
    vram_set_dai_lb_moji(xx+16,yy,3);
    vram_set_dai_lb_moji(xx+32,yy,4);
    vram_set_dai_lb_moji(xx+48,yy,3);
    vram_set_dai_lb_moji(xx+64,yy,2);    
}
void    vram_set_db_dai_moji(unsigned int xx,unsigned int yy)
{
    vram_set_dai_lb_moji(xx,yy,0);
    vram_set_dai_lb_moji(xx+16,yy,1);
}
void    vram_set_freq_out_dai_moji(unsigned int xx,unsigned int yy)
{
    switch(freq_out){
        case 0:
            vram_set_dai_or_moji(xx,yy,0);
            vram_set_dai_or_moji(xx+16,yy,2);
            vram_set_dai_or_moji(xx+32,yy,2);
            break;
        case 1:
            vram_set_dai_or_moji(xx,yy,0);
            vram_set_dai_or_moji(xx+16,yy,1);
            vram_set_dai_clear(xx+32,yy);
            break;
    }
}
void    vram_set_range_dai_moji(unsigned int xx,unsigned int yy)
{
    vram_set_dai_g_moji(xx,yy,0);
    vram_set_dai_g_moji(xx+16,yy,1);
    vram_set_dai_g_moji(xx+32,yy,2);
    vram_set_dai_g_moji(xx+48,yy,3);
    vram_set_dai_g_moji(xx+64,yy,4);
}
void    vram_set_freq_moji(unsigned int xx,unsigned int yy)
{
    vram_set_r_moji(xx,yy,0);
    vram_set_r_moji(xx+8,yy,1);
}
void    vram_set_hz_moji(unsigned int xx,unsigned int yy)
{
    vram_set_r_moji(xx,yy,2);
    vram_set_r_moji(xx+8,yy,3);
}
void    vram_set_level_moji(unsigned int xx,unsigned int yy)
{
    vram_set_lb_moji(xx,yy,0);
    vram_set_lb_moji(xx+8,yy,1);
}
void    vram_set_db_moji(unsigned int xx,unsigned int yy)
{
    vram_set_lb_moji(xx,yy,2);
    vram_set_lb_moji(xx+8,yy,3);
}
/////////////////////////////////////////////////////////////
void    vram_set_freq_data(unsigned int xx,unsigned int yy)
{
    unsigned int    s_data;
    unsigned char   n0,n1,n2,n3,n4;
    
    s_data=(unsigned int)freq_data;
    n0=(unsigned char)(s_data%10);s_data=(s_data-n0)/10;
    n1=(unsigned char)(s_data%10);s_data=(s_data-n1)/10;
    n2=(unsigned char)(s_data%10);s_data=(s_data-n2)/10;
    n3=(unsigned char)(s_data%10);s_data=(s_data-n3)/10;
    n4=(unsigned char)(s_data%10);

    if(n4==0){
        vram_set_dai_clear(xx,yy);
    }
    else{
            vram_set_dai_w_suji(xx,yy,n4);
    }
    if((n4==0)&&(n3==0)){
        vram_set_dai_clear(xx+16,yy);
    }
    else{
            vram_set_dai_w_suji(xx+16,yy,n3);
    }
    if((n4==0)&&(n3==0)&&(n2==0)){
        vram_set_dai_clear(xx+32,yy);
    }
    else{
            vram_set_dai_w_suji(xx+32,yy,n2);
    }
    vram_set_dai_w_suji(xx+48,yy,n1);
    vram_set_dai_w_suji(xx+64,yy,n0);
 
}
void    vram_set_s_freq_data(unsigned int xx,unsigned int yy)
{
    unsigned int    s_data;
    unsigned char   n0,n1,n2,n3,n4;
    
    s_data=(unsigned int)freq_data;
    n0=(unsigned char)(s_data%10);s_data=(s_data-n0)/10;
    n1=(unsigned char)(s_data%10);s_data=(s_data-n1)/10;
    n2=(unsigned char)(s_data%10);s_data=(s_data-n2)/10;
    n3=(unsigned char)(s_data%10);s_data=(s_data-n3)/10;
    n4=(unsigned char)(s_data%10);

    if(n4==0){
        vram_set_s_clear(xx,yy);
    }
    else{
            vram_set_w_suji(xx,yy,n4);
    }
    if((n4==0)&&(n3==0)){
        vram_set_s_clear(xx+8,yy);
    }
    else{
            vram_set_w_suji(xx+8,yy,n3);
    }
    if((n4==0)&&(n3==0)&&(n2==0)){
        vram_set_s_clear(xx+16,yy);
    }
    else{
            vram_set_w_suji(xx+16,yy,n2);
    }
    vram_set_w_suji(xx+24,yy,n1);
    vram_set_w_suji(xx+32,yy,n0);
 
}
void    vram_set_range(unsigned int xx,unsigned int yy)
{
    vram_set_dai_w_suji(xx,yy,range);
}


///////////////////////////////////////////////////////////////
void    vram_set_4pset_level(unsigned int xx,unsigned long data)
{
    long   data0;
    
    data0=data;
    data0=data0*19;
    data0=data0*33;
    data0=data0*5/256;
    switch(db_mode){
        case 0:
            data0=80-(data0-6800)*24/1000;
            break;
        case 1:
            data0=152-(data0-6800)*60/1000;
            data0=data0-db_pointa1*24;
            break;
        case 2:
            break;
    }

    
    if((data0>=32)&&(data0<=216)){
        vram_pset(xx,(unsigned int)data0,5);
        vram_pset(xx+1,(unsigned int)data0,5);
        vram_pset(xx,(unsigned int)data0+1,5);
        vram_pset(xx+1,(unsigned int)data0+1,5);
    }
}
void    vram_set_4line_level(unsigned int x0,unsigned long data_0,unsigned int x1,unsigned long data_1)
{
    long   data0,data1;
    
    data0=data_0;
    //data0=data0*25;
    //data0=data0*27;
    //data0=data0/32;
    
    data1=data_1;
    //data1=data1*25;
    //data1=data1*27;
    //data1=data1/32;    
    
    //data0=80-(data0-7500)*24/1000;
    //data1=80-(data1-7500)*24/1000;

    data0=data0*19;
    data0=data0*33;
    data0=data0*5/256;
    
    data1=data1*19;
    data1=data1*33;
    data1=data1*5/256;
    
    switch(db_mode){
        case 0:
            data0=80-(data0-6800)*24/1000;
            data1=80-(data1-6800)*24/1000;
            break;
        case 1:
            data0=152-(data0-6800)*60/1000;
            data0=data0-db_pointa1*24;
            data1=152-(data1-6800)*60/1000;
            data1=data1-db_pointa1*24;            
            break;
        case 2:
            data0=272-(data0-6800)*120/1000;
            data0=data0-db_pointa2*24;
            data1=272-(data1-6800)*120/1000;
            data1=data1-db_pointa2*24;             
            break;
        case 3:
            data0=128-(data0-6800)*48/1000;
            data0=data0-db_pointa3*24;
            data1=128-(data1-6800)*48/1000;
            data1=data1-db_pointa3*24;               
            break;
    }    
    
    
    vram_line_a(x0,data0,x1,data1,graph_color[graph_color_set][0]);
    vram_line_a(x0+1,data0,x1+1,data1,graph_color[graph_color_set][0]);
    vram_line_a(x0,data0+1,x1,data1+1,graph_color[graph_color_set][0]);
    vram_line_a(x0+1,data0+1,x1+1,data1+1,graph_color[graph_color_set][0]);
}
void    vram_set_8point_level(unsigned int x0,unsigned long data_0)
{
    long   data0;
    
    data0=data_0;

    data0=data0*19;
    data0=data0*33;
    data0=data0*5/256;
    
    switch(db_mode){
        case 0:
            data0=80-(data0-6800)*24/1000;
            break;
        case 1:
            data0=152-(data0-6800)*60/1000;
            data0=data0-db_pointa1*24;
            break;
        case 2:
            data0=272-(data0-6800)*120/1000;
            data0=data0-db_pointa2*24;
            break;
        case 3:
            data0=128-(data0-6800)*48/1000;
            data0=data0-db_pointa3*24;
            break;
    } 
    if((data0>=32)&&(data0<=216)){
        vram_pset(x0,(unsigned int)data0-1,graph_color[graph_color_set][1]);
        vram_pset(x0,(unsigned int)data0,graph_color[graph_color_set][1]);
        vram_pset(x0,(unsigned int)data0+1,graph_color[graph_color_set][1]);
        
        vram_pset(x0-1,(unsigned int)data0-1,graph_color[graph_color_set][1]);
        vram_pset(x0-1,(unsigned int)data0,graph_color[graph_color_set][1]);        
        vram_pset(x0-1,(unsigned int)data0+1,graph_color[graph_color_set][1]);        
        
        vram_pset(x0+1,(unsigned int)data0-1,graph_color[graph_color_set][1]);
        vram_pset(x0+1,(unsigned int)data0,graph_color[graph_color_set][1]);        
        vram_pset(x0+1,(unsigned int)data0+1,graph_color[graph_color_set][1]);   
        
        vram_pset(x0,(unsigned int)data0-2,graph_color[graph_color_set][1]);
        vram_pset(x0,(unsigned int)data0+2,graph_color[graph_color_set][1]);
        vram_pset(x0-2,(unsigned int)data0,graph_color[graph_color_set][1]);
        vram_pset(x0+2,(unsigned int)data0,graph_color[graph_color_set][1]);
        
    }    
}
void    graph_disp(void)
{
    unsigned int    i;
    
    if(sweep_count==158){
        switch(hz_mode){
            case 0:
                for(i=0;i<158;i++){
                    vram_set_4line_level(sweep_x_step0[i],sweep_level_data[i],sweep_x_step0[i+1],sweep_level_data[i+1]);
                }
                break;
            case 1:
                for(i=0;i<73;i++){
                    vram_set_4line_level(sweep_x_step1[i],sweep_level_data[i],sweep_x_step1[i+1],sweep_level_data[i+1]);
                }
                break;
            case 2:
                for(i=0;i<65;i++){
                    vram_set_4line_level(sweep_x_step2[i],sweep_level_data[i+8],sweep_x_step2[i+1],sweep_level_data[i+9]);
                }
                break;
            case 3:
                for(i=0;i<65;i++){
                    vram_set_4line_level(sweep_x_step3[i],sweep_level_data[i+73],sweep_x_step3[i+1],sweep_level_data[i+74]);
                }
                break;
        }

    }
}
void    vram_set_data_point(unsigned int step)
{
    switch(hz_mode){
        case 0:
            vram_set_8point_level(sweep_x_step0[step],sweep_level_data[step]);
            break;
        case 1:
            vram_set_8point_level(sweep_x_step1[step],sweep_level_data[step]);
            break;
        case 2:
            vram_set_8point_level(sweep_x_step2[step-8],sweep_level_data[step]);
            break;
        case 3:
            vram_set_8point_level(sweep_x_step3[step-73],sweep_level_data[step]);
            break;
    }
}
///////////////////////////////////////////////////////////////
/*---------------------AD9834---------------------*/
void    ad9834_data_out(unsigned int data)
{
unsigned int i,mdata;

    mdata=data;
    GPIO_PinWrite(DDS_FSYNC,1);
    GPIO_PinWrite(DDS_SCLK,1);
    GPIO_PinWrite(DDS_FSYNC,0);
    for(i=0;i<16;i++){
        if((mdata & 0x8000) == 0x8000){
            GPIO_PinWrite(DDS_SDATA,1);
        }
        else{
            GPIO_PinWrite(DDS_SDATA,0);
        }
        delay_us(2);
        GPIO_PinWrite(DDS_SCLK,0);
        delay_us(2);
        GPIO_PinWrite(DDS_SCLK,1);
        delay_us(2);
        mdata=mdata <<1;
    }
    GPIO_PinWrite(DDS_FSYNC,1);
}

void    ad9834_freq_set(unsigned long data,unsigned char data2)
{
    unsigned long mdata;
    
    switch(data2){
        case 1:     ad9834_data_out(AD9834_SIG_ON_DATA);
            break;
        case 0:     ad9834_data_out(AD9834_SIG_OFF_DATA);
            break;
    }
    mdata=data*4;
    mdata=(mdata & 0x3fff) | 0x4000;
    ad9834_data_out(mdata);
    mdata=data*4;
    mdata=mdata >> 14;
    mdata=(mdata & 0x3fff) | 0x4000;
    ad9834_data_out(mdata);
}

//////////////////////////////////////////////////////////////
void    freq_up_1_1k(void)
{
    if(freq_data<=999){
        freq_data++;
    }
}
void    freq_up_1_5k(void)
{
    if(freq_data<=4999){
        freq_data++;
    }
}
void    freq_up_1_10k(void)
{
    if(freq_data<=9999){
        freq_data++;
    }
}
void    freq_up_2_20k(void)
{
    if(freq_data<=19998){
        freq_data=freq_data+2;
    }
}
void    freq_down_1_1k(void)
{
    if(freq_data>20){
        freq_data--;
    }
}
void    freq_down_1_5k(void)
{
    if(freq_data>20){
        freq_data--;
    }
}
void    freq_down_1_10k(void)
{
    if(freq_data>20){
        freq_data--;
    }
}
void    freq_down_2_20k(void)
{
    if(freq_data>=22){
        freq_data=freq_data-2;
    }
}
void    freq_up_5_1k(void)
{
    freq_data=freq_data/5;
    freq_data=freq_data*5;
    if(freq_data<=995){
        freq_data=freq_data+5;
    }
}
void    freq_up_5_5k(void)
{
    freq_data=freq_data/5;
    freq_data=freq_data*5;
    if(freq_data<=4995){
        freq_data=freq_data+5;
    }
}
void    freq_up_10_10k(void)
{
    freq_data=freq_data/10;
    freq_data=freq_data*10;
    if(freq_data<=9990){
        freq_data=freq_data+10;
    }
}
void    freq_up_20_20k(void)
{
    freq_data=freq_data/20;
    freq_data=freq_data*20;
    if(freq_data<=19980){
        freq_data=freq_data+20;
    }
}
void    freq_down_5_1k(void)
{
    if((freq_data%5)!=0){
        freq_data=freq_data/5+1;
    }
    else{
        freq_data=freq_data/5;
    }
    freq_data=freq_data*5;
    if(freq_data>=25){
        freq_data=freq_data-5;
    }
}
void    freq_down_5_1k_rep(void)
{
    freq_data=freq_data/5;
    freq_data=freq_data*5;
    if(freq_data>=25){
        freq_data=freq_data-5;
    }
}
void    freq_down_5_5k(void)
{
    if((freq_data%5)!=0){
        freq_data=freq_data/5+1;
    }
    else{
        freq_data=freq_data/5;
    }
    freq_data=freq_data*5;
    if(freq_data>=25){
        freq_data=freq_data-5;
    }
}
void    freq_down_5_5k_rep(void)
{
    freq_data=freq_data/5;
    freq_data=freq_data*5;
    if(freq_data>=25){
        freq_data=freq_data-5;
    }
}
void    freq_down_10_10k(void)
{
    if((freq_data%10)!=0){
        freq_data=freq_data/10+1;    
    }
    else{
        freq_data=freq_data/10;        
    }
    freq_data=freq_data*10;
    if(freq_data>=30){
        freq_data=freq_data-10;
    }
}
void    freq_down_10_10k_rep(void)
{
    freq_data=freq_data/10;
    freq_data=freq_data*10;
    if(freq_data>=30){
        freq_data=freq_data-10;
    }
}
void    freq_down_20_20k(void)
{
    if((freq_data%20)!=0){
        freq_data=freq_data/20+1;    
    }
    else{
        freq_data=freq_data/20;    
    }
    freq_data=freq_data*20;
    if(freq_data>=40){
        freq_data=freq_data-20;
    }
}
void    freq_down_20_20k_rep(void)
{
    freq_data=freq_data/20;
    freq_data=freq_data*20;
    if(freq_data>=40){
        freq_data=freq_data-20;
    }
}
//////////////////////////////////////////////////////////////
void    mode_01_gamen(void)
{
    vram_clear();
    
    vram_set_freq_dai_moji(4*4,5*4);
    vram_set_level_dai_moji(4*4,15*4);
    
    vram_set_hz_dai_moji(24*4,10*4);
    vram_set_db_dai_moji(24*4,20*4);
    
    vram_set_freq_data(4*4,10*4);
    vram_set_freq_out_dai_moji(24*4,5*4);
    
    vram_set_range_dai_moji(4*4,0);
    vram_set_range(24*4,0);
    
    ad9834_freq_set(freq_data,freq_out);
    vram_set_level(4*4,20*4,(unsigned long)level_data);

    vram_set_y_moji(9*4,25*4,5);
    vram_set_y_moji(11*4,25*4,6);
    vram_set_y_moji(9*4,28*4,7);
    vram_set_y_moji(11*4,28*4,1);  
    
    vram_set_m_moji(15*4,25*4,2);
    vram_set_m_moji(17*4,25*4,3);
    vram_set_m_moji(15*4,28*4,4);
    vram_set_m_moji(17*4,28*4,4);

    
    switch(mode){
        case 0:
            if(freq_out==0){
                vram_set_y_moji(4*4,25*4,0);
                vram_set_y_moji(6*4,25*4,1);
            }
            else{
                vram_set_y_moji(4*4,25*4,0);
                vram_set_y_moji(6*4,25*4,2);
            }
            vram_set_y_moji(4*4,28*4,3);
            vram_set_y_moji(6*4,28*4,4);
            vram_set_m_moji(20*4,25*4,4);
            vram_set_m_moji(22*4,25*4,4);
            vram_set_m_moji(20*4,28*4,4);
            vram_set_m_moji(22*4,28*4,4);
            break;
        case 1:
            if(freq_out==0){
                vram_set_y_moji(4*4,25*4,0);
                vram_set_y_moji(6*4,25*4,1);
            }
            else{
                vram_set_y_moji(4*4,25*4,0);
                vram_set_y_moji(6*4,25*4,2);
            }
            vram_set_y_moji(4*4,28*4,4);
            vram_set_y_moji(6*4,28*4,8);
            vram_set_m_moji(20*4,25*4,5);
            vram_set_m_moji(22*4,25*4,6);
            vram_set_m_moji(20*4,28*4,7);
            vram_set_m_moji(22*4,28*4,8);            
            break;
    }

    
    disp_main2();    
}
void    mode_23_gamen(void)
{
    vram_clear();
    
    vram_set_hz_font_main();
    vram_set_db_font_main_1();
    
    vram_set_waku_main_1();
    
    //vram_set_freq_moji(2*4,0);
    vram_set_s_freq_data(10*4,0);
    vram_set_hz_moji(20*4,0);
    
    //vram_set_level_moji(21*4,0);
    vram_set_db_moji(35*4,0);
    vram_set_s_level(25*4,0,(unsigned long)level_data);
    
    switch(mode){
        case 2:
            vram_set_m_moji(0,27*4,1);
            //vram_set_g_moji(0,0,1);
            vram_set_small_moji(0,0,0);
            vram_set_small_moji(3*4,0,2);
            vram_set_small_moji(0,1*4,1);
            vram_set_small_moji(3*4,1*4,3);
            break;
        case 3:
            vram_set_m_moji(0,27*4,0);
            //vram_set_g_moji(0,0,0);
            vram_set_small_moji(0,0,4);
            vram_set_small_moji(3*4,0,5);
            vram_set_small_moji(0,1*4,1);
            vram_set_small_moji(3*4,1*4,6);            
            break;
    }
    
    
    disp_main2();
}
void    mode_23_gamen_2(void)
{
    vram_clear();
    
    vram_set_hz_font_main();
    vram_set_db_font_main_1();
    
    vram_set_waku_main_1();
    
    //vram_set_freq_moji(2*4,0);
    //vram_set_s_freq_data(10*4,0);
    vram_set_hz_moji(20*4,0);
    
    //vram_set_level_moji(21*4,0);
    vram_set_db_moji(35*4,0);
    //vram_set_s_level(25*4,0,(unsigned long)level_data);
    
    switch(mode){
        case 2:
            vram_set_m_moji(0,27*4,1);
            //vram_set_g_moji(0,0,1);
            vram_set_small_moji(0,0,0);
            vram_set_small_moji(3*4,0,2);
            vram_set_small_moji(0,1*4,1);
            vram_set_small_moji(3*4,1*4,3);
            break;
        case 3:
            vram_set_m_moji(0,27*4,0);
            //vram_set_g_moji(0,0,0);
            vram_set_small_moji(0,0,4);
            vram_set_small_moji(3*4,0,5);
            vram_set_small_moji(0,1*4,1);
            vram_set_small_moji(3*4,1*4,6);            
            break;
    }
}
///////////////////////////////////////////////////////////////
uint32_t    adc_read_an13(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN13, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };    
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}
uint32_t    adc_read_an9(void)
{
    uint32_t    ret_data;
    
    ADC_InputSelect(ADC_MUX_A, ADC_INPUT_POSITIVE_AN9, ADC_INPUT_NEGATIVE_VREFL);
    ADC_SamplingStart();
    ADC_ConversionStart();
    while(!ADC_ResultIsReady())
        {

        };
    ret_data=ADC_ResultGet(ADC_RESULT_BUFFER_0);
    
    return ret_data;
}
unsigned int	vol_yomi(void)
{
unsigned short	sa;

	vol_level=adc_read_an9();
	if(vol_level>vol_level_m){
		sa=vol_level-vol_level_m;
	}
	if(vol_level<=vol_level_m){
		sa=vol_level_m-vol_level;
	}
	if(sa>=5){
		vol_level_m=vol_level;
	}
	else{
		vol_level=vol_level_m;
	}

	return vol_level;
}
///////////////////////////////////////////////////////////////
void    vram_set_level(unsigned int xx,unsigned int yy,unsigned long data)
{
long   out_data;
unsigned char   nn;
unsigned char   n0,n1,n2,n3;

    //out_data=data*25;
    //out_data=out_data*27;
    //out_data=out_data/32;
    //if(out_data>7500){
    //    nn=0;
    //    out_data=out_data-7500;
    //}
    //else{
    //    nn=1;
    //    out_data=7500-out_data;
    //}

    out_data=data*19;
    out_data=out_data*33;
    out_data=out_data*5/256;
    if(out_data>6800){
        nn=0;
        out_data=out_data-6800;
    }
    else{
        nn=1;
        out_data=6800-out_data;
    }
    

    //out_data=data;
    //out_data=out_data*103125;
    //out_data=out_data/32;
    //out_data=out_data-2100000;
    //out_data=out_data/238;
    
    //if(out_data>=0){
    //    nn=0;
    //}
    //else{
    //    nn=1;
    //    out_data=-out_data;
    //}





	n0=(unsigned char)(out_data%10);out_data=(out_data-n0)/10;
	n1=(unsigned char)(out_data%10);out_data=(out_data-n1)/10;
    n2=(unsigned char)(out_data%10);out_data=(out_data-n2)/10;
    n3=(unsigned char)(out_data%10);
    
    vram_set_dai_w_suji(xx+16,yy,n3);
    vram_set_dai_w_suji(xx+32,yy,n2);
    vram_set_dai_w_moji(xx+48,yy,0);
    vram_set_dai_w_suji(xx+64,yy,n1);
    if(nn==1){
       vram_set_dai_w_moji(xx,yy,1);
    }
    else{
        vram_set_dai_w_moji(xx,yy,2);
    }
    
    //vram_set_dai_w_suji(xx+16,yy,n3);
    //vram_set_dai_w_suji(xx+32,yy,n2);
    //vram_set_dai_w_suji(xx+48,yy,n1);
    //vram_set_dai_w_suji(xx+64,yy,n0);
    
}
void    vram_set_s_level(unsigned int xx,unsigned int yy,unsigned long data)
{
unsigned long   out_data;
unsigned char   nn;
unsigned char   n0,n1,n2,n3;

    //out_data=data*25;
    //out_data=out_data*27;
    //out_data=out_data/32;
    //if(out_data>7500){
    //    nn=0;
    //    out_data=out_data-7500;
    //}
    //else{
    //    nn=1;
    //    out_data=7500-out_data;
    //}

    out_data=data*19;
    out_data=out_data*33;
    out_data=out_data*5/256;
    if(out_data>6800){
        nn=0;
        out_data=out_data-6800;
    }
    else{
        nn=1;
        out_data=6800-out_data;
    }

	n0=(unsigned char)(out_data%10);out_data=(out_data-n0)/10;
	n1=(unsigned char)(out_data%10);out_data=(out_data-n1)/10;
    n2=(unsigned char)(out_data%10);out_data=(out_data-n2)/10;
    n3=(unsigned char)(out_data%10);
    
    vram_set_w_suji(xx+8,yy,n3);
    vram_set_w_suji(xx+16,yy,n2);
    vram_set_w_moji(xx+24,yy,0);
    vram_set_w_suji(xx+32,yy,n1);
    if(nn==1){
        vram_set_w_moji(xx,yy,1);
    }
    else{
        vram_set_w_moji(xx,yy,2);
    }
}


////////////////////////////////////////////////////
/*---------------------AUTO LEVEL OUT-------------*/
void    level_out(unsigned long freq,unsigned int level)
{
unsigned char   i;

    GPIO_PinWrite(LEVEL_CLK,0);
    GPIO_PinWrite(LEVEL_DATA_P,0);
    
    for(i=0;i<16;i++){
        if((level & 0x01)==0x01){
            GPIO_PinWrite(LEVEL_DATA_P,1);
        }
        else{
            GPIO_PinWrite(LEVEL_DATA_P,0);
        }
        delay_us(50);
        GPIO_PinWrite(LEVEL_CLK,1);
        delay_us(50);
        GPIO_PinWrite(LEVEL_CLK,0);
        delay_us(50);
        level=level >> 1;
    }
     for(i=0;i<24;i++){
        if((freq & 0x01)==0x01){
            GPIO_PinWrite(LEVEL_DATA_P,1);
        }
        else{
            GPIO_PinWrite(LEVEL_DATA_P,0);
        }
        delay_us(50);
        GPIO_PinWrite(LEVEL_CLK,1);
        delay_us(50);
        GPIO_PinWrite(LEVEL_CLK,0);
        delay_us(50);
        freq=freq >> 1;
    }
    GPIO_PinWrite(LEVEL_CLK,0);
    GPIO_PinWrite(LEVEL_DATA_P,0);

}
void    sweep_level_out(void)
{
    unsigned int    i;
    
    if(sweep_count==158){
        for(i=0;i<159;i++){
            level_out(sweep_hz_step0[i],(unsigned int)sweep_level_data[i]);
            delay_ms(50);
        }
    }
}

////////////////////////////////////////////////////
int main ( void )
{
    //unsigned int    testx,testy;
    
    /* Initialize all modules */
    SYS_Initialize ( NULL );

    lcdmode=0;
    
    set_up();
  
    vram_clear();
    disp_main2();
    
    delay_ms(1000);

    mode=0;
    vol_count=0;
    
    db_mode=0;
    db_pointa1=0;
    db_pointa2=0;
    db_pointa3=0;
    
    hz_mode=0;

    freq_data=20;
    freq_out=0;
    
    range=1;
    sweep_flg=0;
    sweep_count=0;
    
    graph_color_set=GRAPH_COLOR_SET_INIT;
    
    //TEST

    
    mode_01_gamen();
    
    
    while ( true )
    {
        /* key scan 1 */
		if (GPIO_PinRead(SW1)==0){
				sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/
		if (GPIO_PinRead(SW2)==0){
				sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/        
		if (GPIO_PinRead(SW3)==0){
				sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/   
		if (GPIO_PinRead(SW4)==0){
				sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
            sw4_loop=0;
		}
		/*------------------*/           
        
        

        
        disp_main2();
        /*------------------*/
        /* key scan 2 */
		if ((GPIO_PinRead(SW1)==0)&&(sw1_key==0)){
			sw1_key=0;
		}
		else{
			sw1_key=1;
			sw1_rep=0;
			sw1_cnt=0;
		}
		/*------------------*/ 
		if ((GPIO_PinRead(SW2)==0)&&(sw2_key==0)){
			sw2_key=0;
		}
		else{
			sw2_key=1;
			sw2_rep=0;
			sw2_cnt=0;
		}
		/*------------------*/  
		if ((GPIO_PinRead(SW3)==0)&&(sw3_key==0)){
			sw3_key=0;
		}
		else{
			sw3_key=1;
			sw3_rep=0;
			sw3_cnt=0;
		}
		/*------------------*/  
		if ((GPIO_PinRead(SW4)==0)&&(sw4_key==0)){
			sw4_key=0;
		}
		else{
			sw4_key=1;
			sw4_rep=0;
			sw4_cnt=0;
            sw4_loop=0;
		}
		/*------------------*/          


        
        /* key action */  
		if((sw1_key==0)&&(sw1_rep==0)){
			sw1_rep=1;
            switch(mode){
                case 0:
                case 1:
                    switch(freq_out){
                        case 0:
                            freq_out=1;
                            
                            break;
                        case 1:
                            freq_out=0;
                            
                            break;
                    }
                    ad9834_freq_set(freq_data,freq_out);
                    //vram_set_freq_out_dai_moji(24*4,5*4);
                    mode_01_gamen();
                    break;
                case 2:
                    mode=3;
                    sweep_flg=0;
                    mode_23_gamen(); 
                    graph_disp();
                    disp_step_m=100;
                    break;
                case 3:
                    mode=2;
                    sweep_flg=0;
                    mode_23_gamen();  
                    graph_disp();
                    disp_step_m=100;
                    break;
            }
        }
		/*------------------*/
		if((sw1_key==0)&&(sw1_rep==1)){
			sw1_cnt++;
			if(sw1_cnt>=KEY_LONG_PUSH){
				sw1_cnt=0;
                switch(mode){
                    case 0:
                    case 1:
                        mode=2;
                        db_mode=0;
                        db_pointa1=0;
                        db_pointa2=0;
                        db_pointa3=0;
                        hz_mode=0;
                        freq_out=0;
                        sweep_flg=0;
                        mode_23_gamen();
                        break;
                    case 2:
                    case 3:
                        mode=0;
                        freq_out=0;
                        mode_01_gamen();
                        break;
                }

			}
		}                
        /*------------------*/
        if((sw2_key==0)&&(sw2_rep==0)){
            sw2_rep=1;
            switch(mode){
                case 0:
                    switch(range){
                        case 1:
                            range=2;
                            break;
                        case 2:
                            range=3;
                            break;
                        case 3:
                            range=4;
                            break;
                        case 4:
                            range=1;
                            break;
                    }
                    //vram_set_range(24*4,0);
                    mode_01_gamen();
                    break;
                case 1:
                    mode=0;
                    vol_count=0;
                    freq_data_m=0;
                    mode_01_gamen();
                    break;
                case 2:
                    switch(db_mode){
                        case 0:
                            db_mode=3;
                            break;
                        case 1:
                            db_mode=2;
                            break;
                        case 2:
                            db_mode=0;
                            break;
                        case 3:
                            db_mode=1;
                            break;
                    }
                    sweep_flg=0;
                    mode_23_gamen();
                    graph_disp();
                    disp_step_m=100;
                    break;
                case 3:
                    switch(hz_mode){
                        case 0:
                            hz_mode=1;
                            break;
                        case 1:
                            hz_mode=2;
                            break;
                        case 2:
                            hz_mode=3;
                            break;
                        case 3:
                            hz_mode=0;
                            break;
                    }
                    sweep_flg=0;
                    mode_23_gamen();
                    graph_disp();
                    disp_step_m=100;
                    break;
            }
        }  
		/*------------------*/
		if((sw2_key==0)&&(sw2_rep==1)){
			sw2_cnt++;
			if(sw2_cnt>=KEY_LONG_PUSH){
				sw2_cnt=0;
                switch(mode){
                    case 0:
                        break;
                    case 1:
                        break;
                    case 2:
                    case 3:
                        switch(graph_color_set){
                            case 0:
                                graph_color_set=1;
                                break;
                            case 1:
                                graph_color_set=2;
                                break;
                            case 2:
                                graph_color_set=3;
                                break;
                            case 3:
                                graph_color_set=0;
                                break;
                        }
                        mode_23_gamen();
                        graph_disp();
                        disp_step_m=100;
                        break;
                }

			}
		}                   
        /*------------------*/ 
        if((sw3_key==0)&&(sw3_rep==0)){
            sw3_rep=1;
            switch(mode){
                case 0:
                    mode=1;
                case 1:
                    switch(range){
                        case 1:
                            freq_up_1_1k();
                            break;
                        case 2:
                            freq_up_1_5k();
                            break;
                        case 3:
                            freq_up_1_10k();
                            break;
                        case 4:
                            freq_up_2_20k();
                            break;
                    }
                    ad9834_freq_set(freq_data,freq_out);
                    //vram_set_freq_data(4*4,10*4);
                    mode_01_gamen();
                    break;
                case 2:
                    switch(db_mode){
                        case 0:
                            break;
                        case 1:
                            if(db_pointa1>=1){
                                db_pointa1=db_pointa1-1;
                            }
                            break;
                        case 2:
                            if(db_pointa2>=1){
                                db_pointa2=db_pointa2-1;
                            }
                            break;
                        case 3:
                            if(db_pointa3>=1){
                                db_pointa3=db_pointa3-1;
                            }
                            break;
                    }
                    sweep_flg=0;
                    mode_23_gamen();
                    graph_disp();
                    disp_step_m=100;
                    break;
                case 3:
                    sweep_flg=1;
                    freq_out=1;
                    db_mode=0;
                    hz_mode=0;
                    db_pointa1=0;
                    db_pointa2=0;
                    db_pointa3=0;
                    sweep_count=0;
                    mode_23_gamen();
                    freq_data=sweep_hz_step0[sweep_count];
                    ad9834_freq_set(freq_data,freq_out);
                    vram_set_s_freq_data(10*4,0);  
                    sweep_loop=SWEEP_LOOP_INIT;           
                    vram_set_m_moji(6*4,0,2);
                    vram_set_m_moji(8*4,0,3);
                    break;
            }
        }  
		/*------------------*/
		if((sw3_key==0)&&(sw3_rep==1)){
			sw3_cnt++;
			if(sw3_cnt>=KEY_LONG_UD){
				sw3_cnt=0;
                switch(mode){
                    case 0:
                        break;
                    case 1:
                        switch(range){
                            case 1:
                                freq_up_5_1k();
                                break;
                            case 2:
                                freq_up_5_5k();
                                break;
                            case 3:
                                freq_up_10_10k();
                                break;
                            case 4:
                                freq_up_20_20k();
                                break;
                        }
                        ad9834_freq_set(freq_data,freq_out);
                        //vram_set_freq_data(4*4,10*4);   
                        mode_01_gamen();
                        break;
                    case 2:
                        switch(db_mode){
                            case 0:
                                break;
                            case 1:
                                if(db_pointa1>=1){
                                    db_pointa1=db_pointa1-1;
                                }
                                break;
                            case 2:
                                if(db_pointa2>=1){
                                    db_pointa2=db_pointa2-1;
                                }
                                break;
                            case 3:
                                if(db_pointa3>=1){
                                    db_pointa3=db_pointa3-1;
                                }
                                break;                                
                        }
                        sweep_flg=0;
                        mode_23_gamen();
                        graph_disp();  
                        disp_step_m=100;
                        break;
                    case 3:
                        break;
                }
			}
		}                
        /*------------------*/            
        if((sw4_key==0)&&(sw4_rep==0)){
            sw4_rep=1;
            switch(mode){
                case 0:
                    mode=1;
                case 1:
                    switch(range){
                        case 1:
                            freq_down_1_1k();
                            break;
                        case 2:
                            freq_down_1_5k();
                            break;
                        case 3:
                            freq_down_1_10k();
                            break;
                        case 4:
                            freq_down_2_20k();
                            break;
                    }
                    ad9834_freq_set(freq_data,freq_out);
                    //vram_set_freq_data(4*4,10*4);
                    mode_01_gamen();
                    break;
                case 2:
                    switch(db_mode){
                        case 0:
                            break;
                        case 1:
                            if(db_pointa1<8){
                                db_pointa1=db_pointa1+1;
                            }
                            break;
                        case 2:
                            if(db_pointa2<23){
                                db_pointa2=db_pointa2+1;
                            }
                            break;
                        case 3:
                            if(db_pointa3<5){
                                db_pointa3=db_pointa3+1;
                            }
                            break;
                    }
                    sweep_flg=0;
                    mode_23_gamen();
                    graph_disp();
                    disp_step_m=100;
                    break;
                case 3:
                    vram_set_b_moji(6*4,0,0);
                    vram_set_b_moji(8*4,0,1);
                    disp_main2();
                    sweep_level_out();
                    vram_set_s_clear(6*4,0);
                    vram_set_s_clear(8*4,0);                    
                    break;
            }
        } 
        /*------------------*/
		if((sw4_key==0)&&(sw4_rep==1)){
			sw4_cnt++;
			if(sw4_cnt>=KEY_LONG_UD){
				sw4_cnt=0;
                switch(mode){
                    case 0:
                        break;
                    case 1:
                        switch(range){
                            case 1:
                                if(sw4_loop==0){
                                    freq_down_5_1k();
                                }
                                else{
                                    freq_down_5_1k_rep();
                                }
                                sw4_loop=1;
                                break;
                            case 2:
                                if(sw4_loop==0){
                                    freq_down_5_5k();
                                }
                                else{
                                    freq_down_5_5k_rep();
                                }
                                break;
                            case 3:
                                if(sw4_loop==0){
                                    freq_down_10_10k();
                                }
                                else{
                                    freq_down_10_10k_rep();
                                }
                                break;
                            case 4:
                                if(sw4_loop==0){
                                    freq_down_20_20k();                                    
                                }
                                else{
                                    freq_down_20_20k_rep();                                    
                                }
                                break;
                        }
                        ad9834_freq_set(freq_data,freq_out);
                        //vram_set_freq_data(4*4,10*4);    
                        mode_01_gamen();
                        break;
                    case 2:
                        switch(db_mode){
                            case 0:
                                break;
                            case 1:
                                if(db_pointa1<8){
                                    db_pointa1=db_pointa1+1;
                                }
                                break;
                            case 2:
                                if(db_pointa2<23){
                                    db_pointa2=db_pointa2+1;
                                }
                                break;
                            case 3:
                                if(db_pointa3<5){
                                    db_pointa3=db_pointa3+1;
                                }
                                break;                                
                        }
                        sweep_flg=0;
                        mode_23_gamen();
                        graph_disp();     
                        disp_step_m=100;
                        break;
                    case 3:
                        break;
                }
			}
		}
        
        
		/*------------------*/        
        switch(mode){
            case 0:
                if(vol_count>0){vol_count--;}
                if(vol_count==0){
                    vol_data=vol_yomi();
                    freq_data=(unsigned long)vol_data/10;
                    switch(range){
                        case 1:
                            freq_data=freq_data*10;
                            break;
                        case 2:
                            freq_data=freq_data*50;
                            break;
                        case 3:
                            freq_data=freq_data*100;
                            break;
                        case 4:
                            freq_data=freq_data*200;
                            break;
                    }
                    if(freq_data<FREQ_MIN){freq_data=FREQ_MIN;}
                    if(freq_data>FREQ_MAX){freq_data=FREQ_MAX;}
                    if(freq_data_m!=freq_data){
                        ad9834_freq_set(freq_data,freq_out);
                        vram_set_freq_data(4*4,10*4);   
                        freq_data_m=freq_data;
                    }
                    vol_count=VOL_COUNT_SET;
                }                                    
                break;
            case 1:
                break;
            case 2:
            case 3:
                if((sweep_count==158)&&(sweep_flg==0)){
                    if(vol_count>0){vol_count--;}
                    if(vol_count==0){
                        vol_data=vol_yomi();
                        vol_step=(unsigned long)vol_data/10;
                        if(vol_step>99){vol_step=99;}
                        switch(hz_mode){
                            case 0:
                                disp_step=sweep_disp_step0[vol_step];
                                break;
                            case 1:
                                disp_step=sweep_disp_step1[vol_step];
                                break;
                            case 2:
                                disp_step=sweep_disp_step2[vol_step]+8;
                                break;
                            case 3:
                                disp_step=sweep_disp_step3[vol_step]+73;
                                break;
                        }
                        if(disp_step_m!=disp_step){
                            freq_data=sweep_hz_step0[disp_step];
                            mode_23_gamen_2();
                            vram_set_s_freq_data(10*4,0);  
                            vram_set_s_level(25*4,0,sweep_level_data[disp_step]);
                            disp_step_m=disp_step;
                            graph_disp();
                            vram_set_data_point(disp_step);
                        }
                        vol_count=VOL_COUNT_SET;
                    }                                                     
                }
                break;
        }

        /*---------------*/
        
        switch(mode){
            case 0:
            case 1:
                if(level_count>0){level_count--;}
                if(level_count==0){
                    level_data=adc_read_an13();
                    level_st[level_st_count]=level_data;
                    level_st_count++;
                    if(level_st_count>4){
                        level_st_count=0;
                        level_data=(level_st[0]+level_st[1]+level_st[2]+level_st[3]+level_st[4])/5;
                        //ms_level=level_data;
                        vram_set_level(4*4,20*4,(unsigned long)level_data);
                        level_count=LEVEL_COUNT_SET;
                    }
                }                
                break;
            case 2:
            case 3:
                if(level_count>0){level_count--;}
                if(level_count==0){
                    level_data=adc_read_an13();
                    level_st[level_st_count]=level_data;
                    level_st_count++;
                    if(level_st_count>4){
                        level_st_count=0;
                        level_data=(level_st[0]+level_st[1]+level_st[2]+level_st[3]+level_st[4])/5;
                        //ms_level=level_data;
                         if(sweep_count!=158){
                            vram_set_s_level(25*4,0,(unsigned long)level_data);
                         }
                        level_count=LEVEL_COUNT_SET;
                    }
                }                       
                break;
        }

        /*---------------*/        
        if(sweep_flg==1){
            if(sweep_loop>0){sweep_loop--;};
            if(sweep_loop==0){
                sweep_level_data[sweep_count]=level_data;
                if(sweep_count==0){
                    //vram_set_4pset_level(sweep_x_step0[sweep_count],level_data);
                }
                else{
                    vram_set_4line_level(sweep_x_step0[sweep_count-1],sweep_level_data[sweep_count-1],sweep_x_step0[sweep_count],level_data);
                }

                level_out(sweep_hz_step0[sweep_count],(unsigned int)level_data);

                if(sweep_count<158){
                    sweep_count++;
                    freq_data=sweep_hz_step0[sweep_count];
                    ad9834_freq_set(freq_data,freq_out);
                    vram_set_s_freq_data(10*4,0);                     
                    sweep_loop=SWEEP_LOOP_INIT;
                }
                else{
                    sweep_flg=0;
                    vram_set_s_clear(6*4,0);
                    vram_set_s_clear(8*4,0);
                    freq_out=0;
                    ad9834_freq_set(freq_data,freq_out);
                }
            }
            
        }
        
 
        /*---------------*/             
        
    }

    /* Execution should not come here during normal operation */

    return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

